/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.generators;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Point2d;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.renderer.RendererModel;
import org.openscience.cdk.renderer.elements.ElementGroup;
import org.openscience.cdk.renderer.elements.IRenderingElement;
import org.openscience.cdk.renderer.elements.OvalElement;
import org.openscience.cdk.renderer.generators.BasicAtomGenerator;
import org.openscience.cdk.renderer.generators.BasicSceneGenerator;
import org.openscience.cdk.renderer.generators.IGenerator;
import org.openscience.cdk.renderer.generators.IGeneratorParameter;
import org.openscience.cdk.renderer.generators.parameter.AbstractGeneratorParameter;

public class HighlightAtomGenerator
extends BasicAtomGenerator
implements IGenerator<IAtomContainer> {
    private IGeneratorParameter<Color> hoverOverColor = new HoverOverColor();
    private HighlightAtomDistance highlightAtomDistance = new HighlightAtomDistance();
    private HighlightAtomShapeFilled highlightAtomShapeFilled = new HighlightAtomShapeFilled();

    private boolean shouldHighlight(IAtom atom, RendererModel model) {
        return !super.isHydrogen(atom) || (Boolean)model.getParameter(BasicAtomGenerator.ShowExplicitHydrogens.class).getValue() != false;
    }

    @Override
    public IRenderingElement generate(IAtomContainer ac, RendererModel model) {
        IAtom atom = model.getHighlightedAtom();
        if (atom != null && this.shouldHighlight(atom, model)) {
            Point2d p = atom.getPoint2d();
            double radius = (Double)model.getParameter(HighlightAtomDistance.class).getValue() / (Double)model.getParameter(BasicSceneGenerator.Scale.class).getValue();
            boolean filled = (Boolean)model.getParameter(HighlightAtomShapeFilled.class).getValue();
            Color highlightColor = this.hoverOverColor.getValue();
            return new OvalElement(p.x, p.y, radius, filled, highlightColor);
        }
        return new ElementGroup();
    }

    @Override
    public List<IGeneratorParameter<?>> getParameters() {
        ArrayList parameters = new ArrayList();
        parameters.add(this.hoverOverColor);
        parameters.add(this.highlightAtomDistance);
        parameters.add(this.highlightAtomShapeFilled);
        parameters.addAll(super.getParameters());
        return parameters;
    }

    public static class HighlightAtomShapeFilled
    extends AbstractGeneratorParameter<Boolean> {
        @Override
        public Boolean getDefault() {
            return Boolean.FALSE;
        }
    }

    public static class HighlightAtomDistance
    extends AbstractGeneratorParameter<Double> {
        @Override
        public Double getDefault() {
            return 8.0;
        }
    }

    public static class HoverOverColor
    extends AbstractGeneratorParameter<Color> {
        @Override
        public Color getDefault() {
            return Color.lightGray;
        }
    }
}

