/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.controller.undoredo;

import java.util.Map;
import java.util.Set;
import javax.swing.undo.CannotUndoException;
import org.openscience.cdk.controller.IChemModelRelay;
import org.openscience.cdk.controller.undoredo.IUndoRedoable;
import org.openscience.cdk.interfaces.IBond;

public class AdjustBondOrdersEdit
implements IUndoRedoable {
    private static final long serialVersionUID = 1513012471000333600L;
    private Map<IBond, IBond.Order[]> changedBondOrders;
    private Map<IBond, IBond.Stereo[]> changedBondsStereo;
    private String type;
    private IChemModelRelay chemModelRelay = null;

    public AdjustBondOrdersEdit(Map<IBond, IBond.Order[]> changedBondsOrder, Map<IBond, IBond.Stereo[]> changedBondsStereo, String type, IChemModelRelay chemModelRelay) {
        this.changedBondOrders = changedBondsOrder;
        this.changedBondsStereo = changedBondsStereo;
        this.type = type;
        this.chemModelRelay = chemModelRelay;
    }

    @Override
    public void redo() {
        Set<IBond> keys = this.changedBondOrders.keySet();
        for (IBond bond : keys) {
            IBond.Order[] bondOrders = this.changedBondOrders.get(bond);
            bond.setOrder(bondOrders[0]);
            this.chemModelRelay.updateAtom(bond.getAtom(0));
            this.chemModelRelay.updateAtom(bond.getAtom(1));
        }
        Set<IBond> keysstereo = this.changedBondsStereo.keySet();
        for (IBond bond : keysstereo) {
            IBond.Stereo[] bondStereos = this.changedBondsStereo.get(bond);
            bond.setStereo(bondStereos[0]);
        }
    }

    @Override
    public void undo() throws CannotUndoException {
        Set<IBond> keys = this.changedBondOrders.keySet();
        for (IBond bond : keys) {
            IBond.Order[] bondOrders = this.changedBondOrders.get(bond);
            bond.setOrder(bondOrders[1]);
            this.chemModelRelay.updateAtom(bond.getAtom(0));
            this.chemModelRelay.updateAtom(bond.getAtom(1));
        }
        Set<IBond> keysstereo = this.changedBondsStereo.keySet();
        for (IBond bond : keysstereo) {
            IBond.Stereo[] bondOrders = this.changedBondsStereo.get(bond);
            bond.setStereo(bondOrders[1]);
        }
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    public String getPresentationName() {
        return this.type;
    }
}

