/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.iterator.event;

import java.io.IOException;
import java.io.Reader;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.io.cml.CMLErrorHandler;
import org.openscience.cdk.io.cml.CMLResolver;
import org.openscience.cdk.io.formats.CMLFormat;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.iterator.event.DefaultEventChemObjectReader;
import org.openscience.cdk.io.iterator.event.EventCMLHandler;
import org.openscience.cdk.io.listener.IReaderListener;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class EventCMLReader
extends DefaultEventChemObjectReader {
    private XMLReader parser;
    private Reader input;
    private IChemObjectBuilder builder;
    private EventCMLHandler cdo;
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(EventCMLReader.class);

    public EventCMLReader(Reader input, IReaderListener listener, IChemObjectBuilder builder) {
        this.init();
        this.input = input;
        this.cdo = new EventCMLHandler(this, builder);
        this.builder = builder;
        this.addChemObjectIOListener(listener);
    }

    @Override
    @TestMethod(value="testGetFormat")
    public IResourceFormat getFormat() {
        return CMLFormat.getInstance();
    }

    @Override
    public IAtomContainer getAtomContainer() {
        return this.cdo.getAtomContainer();
    }

    @TestMethod(value="testSetReader_Reader")
    public void setReader(Reader reader) throws CDKException {
        this.input = reader;
    }

    private void init() {
        boolean success = false;
        if (!success) {
            try {
                SAXParserFactory spf = SAXParserFactory.newInstance();
                spf.setNamespaceAware(true);
                SAXParser saxParser = spf.newSAXParser();
                this.parser = saxParser.getXMLReader();
                logger.info("Using JAXP/SAX XML parser.");
                success = true;
            }
            catch (Exception e) {
                logger.warn("Could not instantiate JAXP/SAX XML reader: ", e.getMessage());
                logger.debug(e);
            }
        }
        if (!success) {
            try {
                this.parser = (XMLReader)this.getClass().getClassLoader().loadClass("gnu.xml.aelfred2.XmlReader").newInstance();
                logger.info("Using Aelfred2 XML parser.");
                success = true;
            }
            catch (Exception e) {
                logger.warn("Could not instantiate Aelfred2 XML reader!");
                logger.debug(e);
            }
        }
        if (!success) {
            try {
                this.parser = (XMLReader)this.getClass().getClassLoader().loadClass("org.apache.xerces.parsers.SAXParser").newInstance();
                logger.info("Using Xerces XML parser.");
                success = true;
            }
            catch (Exception e) {
                logger.warn("Could not instantiate Xerces XML reader!");
                logger.debug(e);
            }
        }
        if (!success) {
            logger.error("Could not instantiate any XML parser!");
        }
    }

    public void process() throws CDKException {
        logger.debug("Started parsing from input...");
        try {
            this.parser.setFeature("http://xml.org/sax/features/validation", false);
            logger.info("Deactivated validation");
        }
        catch (SAXException e) {
            logger.warn("Cannot deactivate validation.");
        }
        this.parser.setContentHandler(new EventCMLHandler(this, this.builder));
        this.parser.setEntityResolver(new CMLResolver());
        this.parser.setErrorHandler(new CMLErrorHandler());
        try {
            logger.debug("Parsing from Reader");
            this.parser.parse(new InputSource(this.input));
        }
        catch (IOException e) {
            String error = "Error while reading file: " + e.getMessage();
            logger.error(error);
            logger.debug(e);
            throw new CDKException(error, e);
        }
        catch (SAXParseException saxe) {
            SAXParseException spe = saxe;
            String error = "Found well-formedness error in line " + spe.getLineNumber();
            logger.error(error);
            logger.debug(saxe);
            throw new CDKException(error, saxe);
        }
        catch (SAXException saxe) {
            String error = "Error while parsing XML: " + saxe.getMessage();
            logger.error(error);
            logger.debug(saxe);
            throw new CDKException(error, saxe);
        }
    }

    @Override
    @TestMethod(value="testClose")
    public void close() throws IOException {
        this.input.close();
    }
}

