/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.controller.edit;

import java.util.Set;
import org.openscience.cdk.controller.Changed;
import org.openscience.cdk.controller.edit.AbstractEdit;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IBond;

public class RemoveBond
extends AbstractEdit {
    IBond bond;

    public static RemoveBond remove(IBond bond) {
        return new RemoveBond(bond);
    }

    private RemoveBond(IBond bond) {
        this.bond = bond;
    }

    @Override
    public Set<Changed> getTypeOfChanges() {
        return RemoveBond.changed(Changed.Structure);
    }

    @Override
    public void redo() {
        IAtom a1 = this.bond.getAtom(0);
        IAtom a2 = this.bond.getAtom(1);
        this.model.removeBond(this.bond);
        this.updateHydrogenCount(a1, a2);
    }

    @Override
    public void undo() {
        this.model.addBond(this.bond);
        this.updateHydrogenCount(this.bond.getAtom(0), this.bond.getAtom(1));
    }
}

