/*
 * Decompiled with CFR 0.152.
 */
package signature.chemistry;

import java.util.ArrayList;
import java.util.List;
import signature.chemistry.Molecule;
import signature.chemistry.MoleculeSignature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChiralCenterFinder {
    public static List<Integer> findTetrahedralChiralCenters(Molecule molecule) {
        ArrayList<Integer> chiralCenterIndices = new ArrayList<Integer>();
        MoleculeSignature molSig = new MoleculeSignature(molecule);
        List<String> signatureStrings = molSig.getVertexSignatureStrings();
        int i = 0;
        while (i < molecule.getAtomCount()) {
            int[] connected = molecule.getConnected(i);
            if (connected.length >= 4) {
                String s0 = signatureStrings.get(connected[0]);
                String s1 = signatureStrings.get(connected[1]);
                String s2 = signatureStrings.get(connected[2]);
                String s3 = signatureStrings.get(connected[3]);
                if (!(s0.equals(s1) || s0.equals(s2) || s0.equals(s3) || s1.equals(s2) || s1.equals(s3) || s2.equals(s3))) {
                    chiralCenterIndices.add(i);
                }
            }
            ++i;
        }
        return chiralCenterIndices;
    }
}

