/*
 * Decompiled with CFR 0.152.
 */
package signature.chemistry;

import java.util.List;
import junit.framework.Assert;
import org.junit.Test;
import signature.SymmetryClass;
import signature.chemistry.ChiralCenterFinder;
import signature.chemistry.Molecule;
import signature.chemistry.MoleculeSignature;

public class ChiralityTest {
    @Test
    public void spiranTest() {
        Molecule mol = new Molecule();
        mol.addAtom("N");
        mol.addMultipleAtoms(12, "C");
        mol.addMultipleAtoms(24, "H");
        mol.addMultipleSingleBonds(0, 1, 4, 5, 8);
        mol.addMultipleSingleBonds(1, 2, 33, 34);
        mol.addMultipleSingleBonds(2, 3, 11, 15);
        mol.addMultipleSingleBonds(3, 4, 12, 16);
        mol.addMultipleSingleBonds(4, 35, 36);
        mol.addMultipleSingleBonds(5, 6, 29, 30);
        mol.addMultipleSingleBonds(6, 7, 9, 13);
        mol.addMultipleSingleBonds(7, 8, 10, 14);
        mol.addMultipleSingleBonds(8, 31, 32);
        mol.addMultipleSingleBonds(9, 17, 18, 19);
        mol.addMultipleSingleBonds(10, 20, 21, 22);
        mol.addMultipleSingleBonds(11, 23, 24, 25);
        mol.addMultipleSingleBonds(12, 26, 27, 28);
        MoleculeSignature molSig = new MoleculeSignature(mol);
        List<SymmetryClass> symmetryClasses = molSig.getSymmetryClasses();
        Assert.assertEquals((int)7, (int)symmetryClasses.size());
        List<Integer> tetraChiralCenters = ChiralCenterFinder.findTetrahedralChiralCenters(mol);
        Assert.assertEquals((int)4, (int)tetraChiralCenters.size());
        Assert.assertEquals((int)2, (int)tetraChiralCenters.get(0));
        Assert.assertEquals((int)3, (int)tetraChiralCenters.get(1));
        Assert.assertEquals((int)6, (int)tetraChiralCenters.get(2));
        Assert.assertEquals((int)7, (int)tetraChiralCenters.get(3));
    }

    @Test
    public void dichlorocyclopropaneTest() {
        Molecule mol = new Molecule();
        mol.addAtom("C");
        mol.addAtom("C");
        mol.addAtom("C");
        mol.addAtom("Cl");
        mol.addAtom("Cl");
        mol.addAtom("H");
        mol.addAtom("H");
        mol.addAtom("H");
        mol.addAtom("H");
        mol.addMultipleSingleBonds(0, 1, 2, 3, 5);
        mol.addMultipleSingleBonds(1, 2, 4, 6);
        mol.addMultipleSingleBonds(2, 7, 8);
        MoleculeSignature molSig = new MoleculeSignature(mol);
        List<SymmetryClass> symmetryClasses = molSig.getSymmetryClasses();
        Assert.assertEquals((int)5, (int)symmetryClasses.size());
        List<Integer> tetraChiralCenters = ChiralCenterFinder.findTetrahedralChiralCenters(mol);
        Assert.assertEquals((int)2, (int)tetraChiralCenters.size());
        Assert.assertEquals((int)0, (int)tetraChiralCenters.get(0));
        Assert.assertEquals((int)1, (int)tetraChiralCenters.get(1));
    }

    @Test
    public void dihydroxyCyclohexane() {
        Molecule mol = new Molecule();
        mol.addMultipleAtoms(6, "C");
        mol.addMultipleAtoms(2, "O");
        mol.addMultipleAtoms(12, "H");
        mol.addMultipleSingleBonds(0, 1, 5, 6, 11);
        mol.addMultipleSingleBonds(1, 2, 12, 13);
        mol.addMultipleSingleBonds(2, 3, 14, 15);
        mol.addMultipleSingleBonds(3, 4, 7, 10);
        mol.addMultipleSingleBonds(4, 5, 16, 17);
        mol.addMultipleSingleBonds(5, 18, 19);
        mol.addMultipleSingleBonds(6, 8);
        mol.addMultipleSingleBonds(7, 9);
        MoleculeSignature molSig = new MoleculeSignature(mol);
        List<SymmetryClass> symmetryClasses = molSig.getSymmetryClasses();
        System.out.println(symmetryClasses);
        Assert.assertEquals((int)6, (int)symmetryClasses.size());
        List<Integer> tetraChiralCenters = ChiralCenterFinder.findTetrahedralChiralCenters(mol);
        Assert.assertTrue((boolean)tetraChiralCenters.isEmpty());
    }
}

