/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.fingerprint;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.fingerprint.IFingerprinter;
import org.openscience.cdk.graph.ConnectivityChecker;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.ringsearch.AllRingsFinder;
import org.openscience.cdk.smiles.smarts.SMARTSQueryTool;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TestClass(value="org.openscience.cdk.fingerprint.MACCSFingerprinterTest")
public class MACCSFingerprinter
implements IFingerprinter {
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(MACCSFingerprinter.class);
    private MaccsKey[] keys = null;

    @TestMethod(value="testFingerprint")
    public MACCSFingerprinter() {
        try {
            this.keys = this.readKeyDef();
        }
        catch (IOException e) {
            logger.debug(e);
        }
        catch (CDKException e) {
            logger.debug(e);
        }
    }

    @Override
    @TestMethod(value="testFingerprint,testfp2")
    public BitSet getFingerprint(IAtomContainer atomContainer) throws CDKException {
        IAtomContainerSet part;
        if (this.keys == null) {
            throw new CDKException("Could not setup key definitions");
        }
        int bitsetLength = this.keys.length;
        BitSet fingerPrint = new BitSet(bitsetLength);
        SMARTSQueryTool sqt = new SMARTSQueryTool("C");
        for (int i = 0; i < this.keys.length; ++i) {
            String smarts = this.keys[i].getSmarts();
            if (smarts.equals("?")) continue;
            int count = this.keys[i].getCount();
            sqt.setSmarts(smarts);
            boolean status = sqt.matches(atomContainer);
            if (!status) continue;
            if (count == 0) {
                fingerPrint.set(i, true);
                continue;
            }
            List<List<Integer>> matches = sqt.getUniqueMatchingAtoms();
            if (matches.size() <= count) continue;
            fingerPrint.set(i, true);
        }
        AllRingsFinder ringFinder = new AllRingsFinder();
        IRingSet rings = ringFinder.findAllRings(atomContainer);
        int ringCount = 0;
        for (int i = 0; i < rings.getAtomContainerCount(); ++i) {
            IAtomContainer ring = rings.getAtomContainer(i);
            boolean allAromatic = true;
            for (IBond bond : ring.bonds()) {
                if (bond.getFlag(5)) continue;
                allAromatic = false;
                break;
            }
            if (allAromatic) {
                ++ringCount;
            }
            if (ringCount <= 1) continue;
            fingerPrint.set(124, true);
            break;
        }
        if ((part = ConnectivityChecker.partitionIntoMolecules(atomContainer)).getAtomContainerCount() > 1) {
            fingerPrint.set(165, true);
        }
        return fingerPrint;
    }

    @Override
    public Map<String, Integer> getRawFingerprint(IAtomContainer iAtomContainer) throws CDKException {
        throw new UnsupportedOperationException();
    }

    @Override
    @TestMethod(value="getsize")
    public int getSize() {
        if (this.keys != null) {
            return this.keys.length;
        }
        return 0;
    }

    private MaccsKey[] readKeyDef() throws IOException, CDKException {
        String line;
        ArrayList<MaccsKey> keys = new ArrayList<MaccsKey>();
        String filename = "org/openscience/cdk/fingerprint/data/maccs.txt";
        InputStream ins = this.getClass().getClassLoader().getResourceAsStream(filename);
        BufferedReader reader = new BufferedReader(new InputStreamReader(ins));
        for (int i = 0; i < 32; ++i) {
            reader.readLine();
        }
        while ((line = reader.readLine()) != null) {
            String data = line.trim().split("\\|")[0];
            String[] toks = data.trim().split("\\s");
            keys.add(new MaccsKey(toks[1], Integer.parseInt(toks[2])));
        }
        if (keys.size() != 166) {
            throw new CDKException("Found " + keys.size() + " keys during setup. Should be 166");
        }
        return keys.toArray(new MaccsKey[0]);
    }

    private class MaccsKey {
        private String smarts;
        private int count;

        private MaccsKey(String smarts, int count) {
            this.smarts = smarts;
            this.count = count;
        }

        public String getSmarts() {
            return this.smarts;
        }

        public int getCount() {
            return this.count;
        }
    }
}

