/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.depict;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.exception.InvalidSmilesException;
import org.openscience.cdk.graph.Cycles;
import org.openscience.cdk.graph.GraphUtil;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.isomorphism.matchers.IQueryAtom;
import org.openscience.cdk.isomorphism.matchers.IQueryAtomContainer;
import org.openscience.cdk.isomorphism.matchers.QueryAtomContainer;
import org.openscience.cdk.isomorphism.matchers.smarts.AnyOrderQueryBond;
import org.openscience.cdk.isomorphism.matchers.smarts.AtomicNumberAtom;
import org.openscience.cdk.isomorphism.matchers.smarts.LogicalOperatorAtom;
import org.openscience.cdk.isomorphism.matchers.smarts.TotalConnectionAtom;
import org.openscience.cdk.isomorphism.matchers.smarts.TotalHCountAtom;
import org.openscience.cdk.isomorphism.matchers.smarts.TotalValencyAtom;
import org.openscience.cdk.sgroup.Sgroup;
import org.openscience.cdk.sgroup.SgroupType;
import org.openscience.cdk.silent.SilentChemObjectBuilder;
import org.openscience.cdk.smiles.SmilesGenerator;
import org.openscience.cdk.smiles.SmilesParser;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public class Abbreviations
implements Iterable<String> {
    private static final int MAX_FRAG = 50;
    private final Map<String, String> connectedAbbreviations = new LinkedHashMap<String, String>();
    private final Map<String, String> disconnectedAbbreviations = new LinkedHashMap<String, String>();
    private final Set<String> labels = new LinkedHashSet<String>();
    private final Set<String> disabled = new HashSet<String>();
    private final SmilesGenerator usmigen = SmilesGenerator.unique();
    private final SmilesParser smipar = new SmilesParser(SilentChemObjectBuilder.getInstance());
    private static final String CUT_BOND = "cutbond";

    @Override
    public Iterator<String> iterator() {
        return Collections.unmodifiableSet(this.labels).iterator();
    }

    public boolean isEnabled(String label) {
        return this.labels.contains(label) && !this.disabled.contains(label);
    }

    public boolean setEnabled(String label, boolean enabled) {
        return enabled ? this.labels.contains(label) && this.disabled.remove(label) : this.labels.contains(label) && this.disabled.add(label);
    }

    private static Set<IBond> findCutBonds(IAtomContainer mol, GraphUtil.EdgeToBondMap bmap, int[][] adjlist) {
        HashSet<IBond> cuts = new HashSet<IBond>();
        int numAtoms = mol.getAtomCount();
        for (int i = 0; i < numAtoms; ++i) {
            IAtom atom = mol.getAtom(i);
            int deg = adjlist[i].length;
            int elem = atom.getAtomicNumber();
            if (elem == 6 && deg <= 2 || deg < 2) continue;
            for (int w : adjlist[i]) {
                IBond bond = bmap.get(i, w);
                if (adjlist[w].length < 2 || bond.isInRing()) continue;
                cuts.add(bond);
            }
        }
        return cuts;
    }

    private static List<IAtomContainer> makeCut(IBond cut, IAtomContainer mol, Map<IAtom, Integer> idx, int[][] adjlist) {
        IAtom nbr;
        IAtom atom;
        IAtom beg = cut.getAtom(0);
        IAtom end = cut.getAtom(1);
        LinkedHashSet<IAtom> bvisit = new LinkedHashSet<IAtom>();
        LinkedHashSet<IAtom> evisit = new LinkedHashSet<IAtom>();
        ArrayDeque<IAtom> queue = new ArrayDeque<IAtom>();
        bvisit.add(beg);
        evisit.add(end);
        queue.add(beg);
        bvisit.add(end);
        while (!queue.isEmpty()) {
            atom = (IAtom)queue.poll();
            bvisit.add(atom);
            for (int w : adjlist[idx.get(atom)]) {
                nbr = mol.getAtom(w);
                if (bvisit.contains(nbr)) continue;
                queue.add(nbr);
            }
        }
        bvisit.remove(end);
        queue.add(end);
        evisit.add(beg);
        while (!queue.isEmpty()) {
            atom = (IAtom)queue.poll();
            evisit.add(atom);
            for (int w : adjlist[idx.get(atom)]) {
                nbr = mol.getAtom(w);
                if (evisit.contains(nbr)) continue;
                queue.add(nbr);
            }
        }
        evisit.remove(beg);
        IChemObjectBuilder bldr = mol.getBuilder();
        IAtomContainer bfrag = bldr.newInstance(IAtomContainer.class, new Object[0]);
        IAtomContainer efrag = bldr.newInstance(IAtomContainer.class, new Object[0]);
        int diff = bvisit.size() - evisit.size();
        if (diff < -10) {
            evisit.clear();
        } else if (diff > 10) {
            bvisit.clear();
        }
        if (!bvisit.isEmpty()) {
            bfrag.addAtom(bldr.newInstance(IPseudoAtom.class, new Object[0]));
            for (IAtom atom2 : bvisit) {
                bfrag.addAtom(atom2);
            }
            bfrag.addBond(0, 1, cut.getOrder());
            bfrag.getBond(0).setProperty(CUT_BOND, cut);
        }
        if (!evisit.isEmpty()) {
            efrag.addAtom(bldr.newInstance(IPseudoAtom.class, new Object[0]));
            for (IAtom atom2 : evisit) {
                efrag.addAtom(atom2);
            }
            efrag.addBond(0, 1, cut.getOrder());
            efrag.getBond(0).setProperty(CUT_BOND, cut);
        }
        for (IBond bond : mol.bonds()) {
            IAtom a1 = bond.getAtom(0);
            IAtom a2 = bond.getAtom(1);
            if (bvisit.contains(a1) && bvisit.contains(a2)) {
                bfrag.addBond(bond);
                continue;
            }
            if (!evisit.contains(a1) || !evisit.contains(a2)) continue;
            efrag.addBond(bond);
        }
        ArrayList<IAtomContainer> res = new ArrayList<IAtomContainer>();
        if (!bfrag.isEmpty()) {
            res.add(bfrag);
        }
        if (!efrag.isEmpty()) {
            res.add(efrag);
        }
        return res;
    }

    private static List<IAtomContainer> generateFragments(IAtomContainer mol) {
        GraphUtil.EdgeToBondMap bmap = GraphUtil.EdgeToBondMap.withSpaceFor(mol);
        int[][] adjlist = GraphUtil.toAdjList(mol, bmap);
        Cycles.markRingAtomsAndBonds(mol, adjlist, bmap);
        Set<IBond> cuts = Abbreviations.findCutBonds(mol, bmap, adjlist);
        HashMap<IAtom, Integer> atmidx = new HashMap<IAtom, Integer>();
        for (IAtom atom : mol.atoms()) {
            atmidx.put(atom, atmidx.size());
        }
        ArrayList<IAtomContainer> frags = new ArrayList<IAtomContainer>();
        for (IBond cut : cuts) {
            if (frags.size() >= 50) break;
            frags.addAll(Abbreviations.makeCut(cut, mol, atmidx, adjlist));
        }
        Collections.sort(frags, new Comparator<IAtomContainer>(){

            @Override
            public int compare(IAtomContainer a, IAtomContainer b) {
                return -Integer.compare(a.getBondCount(), b.getBondCount());
            }
        });
        return frags;
    }

    public List<Sgroup> generate(IAtomContainer mol) {
        HashSet<IAtom> usedAtoms = new HashSet<IAtom>();
        List sgroups = (List)mol.getProperty("cdk:CtabSgroups");
        if (sgroups != null) {
            for (Sgroup sgroup : sgroups) {
                usedAtoms.addAll(sgroup.getAtoms());
            }
        }
        if (usedAtoms.isEmpty()) {
            try {
                String cansmi = this.usmigen.create(AtomContainerManipulator.copyAndSuppressedHydrogens(mol));
                String label = this.disconnectedAbbreviations.get(cansmi);
                if (label != null && !this.disabled.contains(label)) {
                    Sgroup sgroup = new Sgroup();
                    sgroup.setType(SgroupType.CtabAbbreviation);
                    sgroup.setSubscript(label);
                    for (IAtom atom : mol.atoms()) {
                        sgroup.addAtom(atom);
                    }
                    return Collections.singletonList(sgroup);
                }
            }
            catch (CDKException cansmi) {
                // empty catch block
            }
        }
        ArrayList<Sgroup> newSgroups = new ArrayList<Sgroup>();
        List<IAtomContainer> fragments = Abbreviations.generateFragments(mol);
        for (IAtomContainer frag : fragments) {
            try {
                String smi = this.usmigen.create(AtomContainerManipulator.copyAndSuppressedHydrogens(frag));
                String label = this.connectedAbbreviations.get(smi);
                if (label == null || this.disabled.contains(label)) continue;
                boolean overlap = false;
                int numAtoms = frag.getAtomCount();
                int numBonds = frag.getBondCount();
                for (int i = 1; i < numAtoms; ++i) {
                    if (!usedAtoms.contains(frag.getAtom(i))) continue;
                    overlap = true;
                    break;
                }
                if (overlap) continue;
                Sgroup sgroup = new Sgroup();
                sgroup.setType(SgroupType.CtabAbbreviation);
                sgroup.setSubscript(label);
                sgroup.addBond(frag.getBond(0).getProperty(CUT_BOND, IBond.class));
                for (int i = 1; i < numAtoms; ++i) {
                    IAtom atom = frag.getAtom(i);
                    usedAtoms.add(atom);
                    sgroup.addAtom(atom);
                }
                newSgroups.add(sgroup);
            }
            catch (CDKException cDKException) {}
        }
        return newSgroups;
    }

    public int apply(IAtomContainer mol) {
        List<Sgroup> newSgroups = this.generate(mol);
        ArrayList<Sgroup> sgroups = (ArrayList<Sgroup>)mol.getProperty("cdk:CtabSgroups");
        sgroups = sgroups == null ? new ArrayList<Sgroup>() : new ArrayList(sgroups);
        int prev = sgroups.size();
        for (Sgroup sgroup : newSgroups) {
            double coverage = (double)sgroup.getAtoms().size() / (double)mol.getAtomCount();
            if (!sgroup.getBonds().isEmpty() && !(coverage < 0.4)) continue;
            sgroups.add(sgroup);
        }
        mol.setProperty("cdk:CtabSgroups", Collections.unmodifiableList(sgroups));
        return sgroups.size() - prev;
    }

    private IQueryAtom matchExact(IAtomContainer mol, IAtom atom) {
        int hcnt;
        IChemObjectBuilder bldr = atom.getBuilder();
        int elem = atom.getAtomicNumber();
        if (elem == 0) {
            return null;
        }
        int val = hcnt = atom.getImplicitHydrogenCount().intValue();
        int con = hcnt;
        for (IBond bond : mol.getConnectedBondsList(atom)) {
            val += bond.getOrder().numeric().intValue();
            ++con;
            if (bond.getConnectedAtom(atom).getAtomicNumber() != 1) continue;
            ++hcnt;
        }
        return LogicalOperatorAtom.and(LogicalOperatorAtom.and(new AtomicNumberAtom(elem, bldr), new TotalConnectionAtom(con, bldr)), LogicalOperatorAtom.and(new TotalHCountAtom(hcnt, bldr), new TotalValencyAtom(val, bldr)));
    }

    private IQueryAtomContainer matchExact(IAtomContainer mol) {
        IChemObjectBuilder bldr = mol.getBuilder();
        QueryAtomContainer qry = new QueryAtomContainer(mol.getBuilder());
        HashMap<IAtom, IQueryAtom> atmmap = new HashMap<IAtom, IQueryAtom>();
        for (IAtom atom : mol.atoms()) {
            IQueryAtom qatom = this.matchExact(mol, atom);
            if (qatom == null) continue;
            atmmap.put(atom, qatom);
            qry.addAtom(qatom);
        }
        for (IBond bond : mol.bonds()) {
            IAtom beg = (IAtom)atmmap.get(bond.getAtom(0));
            IAtom end = (IAtom)atmmap.get(bond.getAtom(1));
            if (beg == null || end == null) continue;
            AnyOrderQueryBond qbond = new AnyOrderQueryBond(bldr);
            qbond.setAtom(beg, 0);
            qbond.setAtom(end, 1);
            qry.addBond(qbond);
        }
        return qry;
    }

    private boolean addDisconnectedAbbreviation(IAtomContainer mol, String label) {
        try {
            String cansmi = SmilesGenerator.unique().create(mol);
            this.disconnectedAbbreviations.put(cansmi, label);
            this.labels.add(label);
            return true;
        }
        catch (CDKException e) {
            return false;
        }
    }

    private boolean addConnectedAbbreviation(IAtomContainer mol, String label) {
        try {
            this.connectedAbbreviations.put(this.usmigen.create(mol), label);
            this.labels.add(label);
            return true;
        }
        catch (CDKException e) {
            return false;
        }
    }

    public boolean add(String line) throws InvalidSmilesException {
        return this.add(this.smipar.parseSmiles(line), Abbreviations.getSmilesSuffix(line));
    }

    public boolean add(IAtomContainer mol, String label) {
        if (label == null || label.isEmpty()) {
            return false;
        }
        int numAttach = 0;
        for (IAtom atom : mol.atoms()) {
            if (atom.getImplicitHydrogenCount() == null || atom.getAtomicNumber() == null) {
                throw new IllegalArgumentException("Implicit hydrogen count or atomic number is null");
            }
            if (atom.getAtomicNumber() != 0) continue;
            ++numAttach;
        }
        switch (numAttach) {
            case 0: {
                return this.addDisconnectedAbbreviation(mol, label);
            }
            case 1: {
                return this.addConnectedAbbreviation(mol, label);
            }
        }
        return false;
    }

    private static String getSmilesSuffix(String line) {
        int last = line.length() - 1;
        for (int i = 0; i < last; ++i) {
            if (line.charAt(i) != ' ' && line.charAt(i) != '\t') continue;
            return line.substring(i + 1).trim();
        }
        return "";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int loadSmiles(InputStream in) throws IOException {
        int count = 0;
        try (BufferedReader brdr = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
            String line;
            while ((line = brdr.readLine()) != null) {
                if (line.isEmpty() || line.charAt(0) == '#') continue;
                try {
                    if (!this.add(line)) continue;
                    ++count;
                }
                catch (InvalidSmilesException e) {
                    e.printStackTrace();
                }
            }
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int loadFromFile(String path) throws IOException {
        try (InputStream in = null;){
            in = this.getClass().getResourceAsStream(path);
            if (in != null) {
                int n = this.loadSmiles(in);
                return n;
            }
            File file = new File(path);
            if (file.exists() && file.canRead()) {
                int n = this.loadSmiles(new FileInputStream(file));
                return n;
            }
        }
        return 0;
    }
}

