/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.hash.stereo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.openscience.cdk.hash.stereo.BasicPermutationParity;
import org.openscience.cdk.hash.stereo.CombinedPermutationParity;
import org.openscience.cdk.hash.stereo.GeometricParity;
import org.openscience.cdk.hash.stereo.GeometryEncoder;
import org.openscience.cdk.hash.stereo.MultiStereoEncoder;
import org.openscience.cdk.hash.stereo.PermutationParity;
import org.openscience.cdk.hash.stereo.StereoEncoder;
import org.openscience.cdk.hash.stereo.StereoEncoderFactory;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IDoubleBondStereochemistry;
import org.openscience.cdk.interfaces.IStereoElement;

public final class DoubleBondElementEncoderFactory
implements StereoEncoderFactory {
    @Override
    public StereoEncoder create(IAtomContainer container, int[][] graph) {
        Map<IAtom, Integer> atomToIndex = null;
        ArrayList<StereoEncoder> encoders = new ArrayList<StereoEncoder>();
        for (IStereoElement se : container.stereoElements()) {
            if (!(se instanceof IDoubleBondStereochemistry)) continue;
            atomToIndex = DoubleBondElementEncoderFactory.indexMap(atomToIndex, container);
            encoders.add(DoubleBondElementEncoderFactory.encoder((IDoubleBondStereochemistry)se, atomToIndex, graph));
        }
        return encoders.isEmpty() ? StereoEncoder.EMPTY : new MultiStereoEncoder(encoders);
    }

    private static GeometryEncoder encoder(IDoubleBondStereochemistry dbs, Map<IAtom, Integer> atomToIndex, int[][] graph) {
        IBond db = dbs.getStereoBond();
        int u = atomToIndex.get(db.getAtom(0));
        int v = atomToIndex.get(db.getAtom(1));
        IBond[] bs = dbs.getBonds();
        int[] us = new int[2];
        int[] vs = new int[2];
        us[0] = atomToIndex.get(bs[0].getConnectedAtom(db.getAtom(0)));
        us[1] = graph[u].length == 2 ? u : DoubleBondElementEncoderFactory.findOther(graph[u], v, us[0]);
        vs[0] = atomToIndex.get(bs[1].getConnectedAtom(db.getAtom(1)));
        vs[1] = graph[v].length == 2 ? v : DoubleBondElementEncoderFactory.findOther(graph[v], u, vs[0]);
        int parity = dbs.getStereo() == IDoubleBondStereochemistry.Conformation.OPPOSITE ? 1 : -1;
        GeometricParity geomParity = GeometricParity.valueOf(parity);
        CombinedPermutationParity permParity = new CombinedPermutationParity(us[1] == u ? BasicPermutationParity.IDENTITY : new BasicPermutationParity(us), vs[1] == v ? BasicPermutationParity.IDENTITY : new BasicPermutationParity(vs));
        return new GeometryEncoder(new int[]{u, v}, (PermutationParity)permParity, geomParity);
    }

    private static int findOther(int[] vs, int u, int x) {
        for (int v : vs) {
            if (v == u || v == x) continue;
            return v;
        }
        throw new IllegalArgumentException("vs[] did not contain another vertex");
    }

    private static Map<IAtom, Integer> indexMap(Map<IAtom, Integer> map, IAtomContainer container) {
        if (map != null) {
            return map;
        }
        map = new HashMap<IAtom, Integer>();
        for (IAtom a : container.atoms()) {
            map.put(a, map.size());
        }
        return map;
    }
}

