/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.generators;

import java.awt.Color;
import java.util.Collections;
import java.util.List;
import org.openscience.cdk.geometry.GeometryUtil;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.renderer.RendererModel;
import org.openscience.cdk.renderer.elements.IRenderingElement;
import org.openscience.cdk.renderer.elements.RectangleElement;
import org.openscience.cdk.renderer.generators.IGenerator;
import org.openscience.cdk.renderer.generators.IGeneratorParameter;

public class AtomContainerBoundsGenerator
implements IGenerator<IAtomContainer> {
    @Override
    public IRenderingElement generate(IAtomContainer container, RendererModel model) {
        double[] minMax = GeometryUtil.getMinMax(container);
        return new RectangleElement(minMax[0], minMax[1], minMax[2], minMax[3], new Color(0.7f, 0.7f, 1.0f));
    }

    @Override
    public List<IGeneratorParameter<?>> getParameters() {
        return Collections.emptyList();
    }
}

