/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.dict;

import org.openscience.cdk.dict.Dictionary;
import org.openscience.cdk.dict.Entry;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class DictionaryHandler
extends DefaultHandler {
    private boolean inEntry = false;
    private boolean inMetadataList = false;
    Entry entry;
    private String currentChars;
    Dictionary dict;

    public void doctypeDecl(String name, String publicId, String systemId) throws Exception {
    }

    public void startDocument() {
        this.dict = new Dictionary();
    }

    public void endElement(String uri, String local, String raw) {
        if ("entry".equals(local) && !"bibtex:entry".equals(raw) && this.inEntry) {
            this.dict.addEntry(this.entry);
            this.inEntry = false;
        } else if ("metadataList".equals(local) && this.inMetadataList) {
            this.inMetadataList = false;
        }
    }

    public void startElement(String uri, String local, String raw, Attributes atts) {
        int i;
        this.currentChars = "";
        if ("entry".equals(local) && !"bibtex:entry".equals(raw) && !this.inEntry) {
            this.inEntry = true;
            this.entry = new Entry();
            for (i = 0; i < atts.getLength(); ++i) {
                if (atts.getQName(i).equals("id")) {
                    this.entry.setID(atts.getValue(i));
                    continue;
                }
                if (!atts.getQName(i).equals("term")) continue;
                this.entry.setLabel(atts.getValue(i));
            }
        }
        if ("metadataList".equals(local) && !this.inMetadataList) {
            this.inMetadataList = true;
        }
        if ("metadata".equals(local) && this.inMetadataList) {
            for (i = 0; i < atts.getLength() - 1; i += 2) {
                String content;
                String dictRefValue = "";
                if (atts.getQName(i).equals("dictRef")) {
                    dictRefValue = atts.getValue(i);
                }
                if (!atts.getQName(i + 1).equals("content") || (content = atts.getValue(i + 1)).indexOf("qsar-descriptors-metadata:") != 0) continue;
                this.entry.setDescriptorMetadata(dictRefValue + "/" + content);
            }
        }
    }

    public void characters(char[] character, int start, int length) {
        this.currentChars = this.currentChars + new String(character, start, length);
    }

    public Dictionary getDictionary() {
        return this.dict;
    }
}

