/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.group;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TestClass(value="org.openscience.cdk.group.PermutationTest")
public final class Permutation {
    private final int[] values;

    @TestMethod(value="sizeNConstructor")
    public Permutation(int size) {
        this.values = new int[size];
        for (int i = 0; i < size; ++i) {
            this.values[i] = i;
        }
    }

    @TestMethod(value="valuesConstructor")
    public Permutation(int ... values) {
        this.values = values;
    }

    @TestMethod(value="cloneConstructor")
    public Permutation(Permutation other) {
        this.values = (int[])other.values.clone();
    }

    @TestMethod(value="equalsTest,equalsTest_null,equalsTest_difference")
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        return Arrays.equals(this.values, ((Permutation)other).values);
    }

    public int hashCode() {
        return Arrays.hashCode(this.values);
    }

    @TestMethod(value="isIdentityTest")
    public boolean isIdentity() {
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] == i) continue;
            return false;
        }
        return true;
    }

    @TestMethod(value="sizeTest")
    public int size() {
        return this.values.length;
    }

    @TestMethod(value="getTest")
    public int get(int index) {
        return this.values[index];
    }

    @TestMethod(value="getValuesTest")
    public int[] getValues() {
        return this.values;
    }

    @TestMethod(value="firstIndexDiffTest")
    public int firstIndexOfDifference(Permutation other) {
        int r;
        for (r = 0; r < this.values.length && this.values[r] == other.get(r); ++r) {
        }
        return r;
    }

    @TestMethod(value="getOrbitTest")
    public List<Integer> getOrbit(int element) {
        ArrayList<Integer> orbit = new ArrayList<Integer>();
        orbit.add(element);
        int i = this.values[element];
        while (i != element && orbit.size() < this.values.length) {
            orbit.add(i);
            i = this.values[i];
        }
        return orbit;
    }

    @TestMethod(value="setTest")
    public void set(int index, int value) {
        this.values[index] = value;
    }

    @TestMethod(value="setToTest")
    public void setTo(Permutation other) {
        if (this.values.length != other.values.length) {
            throw new IllegalArgumentException("permutations are different size");
        }
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = other.values[i];
        }
    }

    @TestMethod(value="multiplyTest")
    public Permutation multiply(Permutation other) {
        Permutation newPermutation = new Permutation(this.values.length);
        for (int i = 0; i < this.values.length; ++i) {
            newPermutation.values[i] = this.values[other.values[i]];
        }
        return newPermutation;
    }

    @TestMethod(value="invertTest")
    public Permutation invert() {
        Permutation inversion = new Permutation(this.values.length);
        for (int i = 0; i < this.values.length; ++i) {
            inversion.values[this.values[i]] = i;
        }
        return inversion;
    }

    @TestMethod(value="toCycleStringTest")
    public String toCycleString() {
        int n = this.values.length;
        boolean[] p = new boolean[n];
        Arrays.fill(p, true);
        StringBuilder sb = new StringBuilder();
        int j = 0;
        for (int i = 0; i < n; ++i) {
            if (!p[i]) continue;
            sb.append('(');
            sb.append(i);
            p[i] = false;
            j = i;
            while (p[this.values[j]]) {
                sb.append(", ");
                j = this.values[j];
                sb.append(j);
                p[j] = false;
            }
            sb.append(')');
        }
        return sb.toString();
    }

    public String toString() {
        return Arrays.toString(this.values);
    }
}

