/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.cml;

import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.io.cml.CMLCoreModule;
import org.openscience.cdk.io.cml.CMLStack;
import org.openscience.cdk.io.cml.ICMLModule;
import org.openscience.cdk.libio.md.ChargeGroup;
import org.openscience.cdk.libio.md.MDMolecule;
import org.openscience.cdk.libio.md.Residue;
import org.xml.sax.Attributes;

public class MDMoleculeConvention
extends CMLCoreModule {
    private Residue currentResidue;
    private ChargeGroup currentChargeGroup;

    public MDMoleculeConvention(IChemFile chemFile) {
        super(chemFile);
    }

    public MDMoleculeConvention(ICMLModule conv) {
        super(conv);
    }

    public void startElement(CMLStack xpath, String uri, String local, String raw, Attributes atts) {
        if ("molecule".equals(local)) {
            if (atts.getValue("convention") != null && atts.getValue("convention").equals("md:mdMolecule")) {
                super.startElement(xpath, uri, local, raw, atts);
                this.currentMolecule = new MDMolecule(this.currentMolecule);
            } else {
                String string = this.DICTREF = atts.getValue("dictRef") != null ? atts.getValue("dictRef") : "";
                if (this.DICTREF.equals("md:chargeGroup")) {
                    this.currentChargeGroup = new ChargeGroup();
                } else if (this.DICTREF.equals("md:residue")) {
                    this.currentResidue = new Residue();
                    if (atts.getValue("title") != null) {
                        this.currentResidue.setName(atts.getValue("title"));
                    }
                }
            }
        } else if ("scalar".equals(local)) {
            this.DICTREF = atts.getValue("dictRef");
            if ("md:switchingAtom".equals(this.DICTREF)) {
                System.out.println("Adding Switching atom: " + this.currentAtom);
                this.currentChargeGroup.setSwitchingAtom(this.currentAtom);
            } else {
                super.startElement(xpath, uri, local, raw, atts);
            }
        } else if ("atom".equals(local)) {
            if (this.currentChargeGroup != null) {
                String id = atts.getValue("ref");
                if (id != null) {
                    this.currentAtom = null;
                    for (IAtom nextAtom : this.currentMolecule.atoms()) {
                        if (!nextAtom.getID().equals(id)) continue;
                        this.currentAtom = nextAtom;
                    }
                    if (this.currentAtom == null) {
                        this.logger.error("Could not found the referenced atom '" + id + "' for this charge group!");
                    } else {
                        this.currentChargeGroup.addAtom(this.currentAtom);
                    }
                }
            } else if (this.currentResidue != null) {
                String id = atts.getValue("ref");
                if (id != null) {
                    IAtom referencedAtom = null;
                    for (IAtom nextAtom : this.currentMolecule.atoms()) {
                        if (!nextAtom.getID().equals(id)) continue;
                        referencedAtom = nextAtom;
                    }
                    if (referencedAtom == null) {
                        this.logger.error("Could not found the referenced atom '" + id + "' for this residue!");
                    } else {
                        this.currentResidue.addAtom(referencedAtom);
                    }
                }
            } else {
                super.startElement(xpath, uri, local, raw, atts);
            }
        } else {
            super.startElement(xpath, uri, local, raw, atts);
        }
    }

    public void endElement(CMLStack xpath, String uri, String name, String raw) {
        if (name.equals("molecule")) {
            if (this.currentChargeGroup != null) {
                if (this.currentMolecule instanceof MDMolecule) {
                    ((MDMolecule)this.currentMolecule).addChargeGroup(this.currentChargeGroup);
                } else {
                    this.logger.error("Need to store a charge group, but the current molecule is not a MDMolecule!");
                }
                this.currentChargeGroup = null;
            } else if (this.currentResidue != null) {
                if (this.currentMolecule instanceof MDMolecule) {
                    ((MDMolecule)this.currentMolecule).addResidue(this.currentResidue);
                } else {
                    this.logger.error("Need to store a residue group, but the current molecule is not a MDMolecule!");
                }
                this.currentResidue = null;
            } else {
                super.endElement(xpath, uri, name, raw);
            }
        } else if ("atomArray".equals(name)) {
            if (xpath.length() == 2 && xpath.endsWith("molecule", "atomArray")) {
                this.storeAtomData();
                this.newAtomData();
            } else if (xpath.length() > 2 && xpath.endsWith("cml", "molecule", "atomArray")) {
                this.storeAtomData();
                this.newAtomData();
            }
        } else if ("bondArray".equals(name)) {
            if (xpath.length() == 2 && xpath.endsWith("molecule", "bondArray")) {
                this.storeBondData();
                this.newBondData();
            } else if (xpath.length() > 2 && xpath.endsWith("cml", "molecule", "bondArray")) {
                this.storeBondData();
                this.newBondData();
            }
        } else if ("scalar".equals(name)) {
            if ("md:resNumber".equals(this.DICTREF)) {
                int myInt = Integer.parseInt(this.currentChars);
                this.currentResidue.setNumber(myInt);
            } else if ("md:cgNumber".equals(this.DICTREF)) {
                int myInt = Integer.parseInt(this.currentChars);
                this.currentChargeGroup.setNumber(myInt);
            }
        } else {
            super.endElement(xpath, uri, name, raw);
        }
    }
}

