/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.iterator;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.NoSuchElementException;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.PubChemCompoundsXMLFormat;
import org.openscience.cdk.io.iterator.DefaultIteratingChemObjectReader;
import org.openscience.cdk.io.pubchemxml.PubChemXMLHelper;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IteratingPCCompoundXMLReader
extends DefaultIteratingChemObjectReader<IAtomContainer> {
    private Reader primarySource;
    private XmlPullParser parser;
    private PubChemXMLHelper parserHelper;
    private IChemObjectBuilder builder;
    private boolean nextAvailableIsKnown;
    private boolean hasNext;
    private IAtomContainer nextMolecule;

    public IteratingPCCompoundXMLReader(Reader in, IChemObjectBuilder builder) throws IOException, XmlPullParserException {
        this.builder = builder;
        this.parserHelper = new PubChemXMLHelper(builder);
        XmlPullParserFactory factory = XmlPullParserFactory.newInstance(System.getProperty("org.xmlpull.v1.XmlPullParserFactory"), null);
        factory.setNamespaceAware(true);
        this.parser = factory.newPullParser();
        this.primarySource = in;
        this.parser.setInput(this.primarySource);
        this.nextMolecule = null;
        this.nextAvailableIsKnown = false;
        this.hasNext = false;
    }

    public IteratingPCCompoundXMLReader(InputStream in, IChemObjectBuilder builder) throws Exception {
        this(new InputStreamReader(in), builder);
    }

    @Override
    @TestMethod(value="testGetFormat")
    public IResourceFormat getFormat() {
        return PubChemCompoundsXMLFormat.getInstance();
    }

    @Override
    public boolean hasNext() {
        if (!this.nextAvailableIsKnown) {
            this.hasNext = false;
            try {
                if (this.parser.next() == 1) {
                    return false;
                }
                while (this.parser.next() != 1) {
                    if (this.parser.getEventType() != 2 || !this.parser.getName().equals("PC-Compound")) continue;
                    this.hasNext = true;
                    break;
                }
                if (this.hasNext) {
                    this.nextMolecule = this.parserHelper.parseMolecule(this.parser, this.builder);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.hasNext = false;
            }
            if (!this.hasNext) {
                this.nextMolecule = null;
            }
            this.nextAvailableIsKnown = true;
        }
        return this.hasNext;
    }

    @Override
    public IAtomContainer next() {
        if (!this.nextAvailableIsKnown) {
            this.hasNext();
        }
        this.nextAvailableIsKnown = false;
        if (!this.hasNext) {
            throw new NoSuchElementException();
        }
        return this.nextMolecule;
    }

    @Override
    @TestMethod(value="testClose")
    public void close() throws IOException {
        this.primarySource.close();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    @TestMethod(value="testSetReader_Reader")
    public void setReader(Reader reader) throws CDKException {
        this.primarySource = reader;
        try {
            this.parser.setInput(this.primarySource);
        }
        catch (XmlPullParserException e) {
            throw new CDKException("Error while opening the input:" + e.getMessage(), e);
        }
        this.nextMolecule = null;
        this.nextAvailableIsKnown = false;
        this.hasNext = false;
    }

    @Override
    @TestMethod(value="testSetReader_InputStream")
    public void setReader(InputStream reader) throws CDKException {
        this.setReader(new InputStreamReader(reader));
    }
}

