/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.debug;

import java.util.Map;
import org.openscience.cdk.ReactionSet;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.debug.DebugChemObjectBuilder;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IChemObjectChangeEvent;
import org.openscience.cdk.interfaces.IChemObjectListener;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.interfaces.IReactionSet;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class DebugReactionSet
extends ReactionSet
implements IReactionSet {
    private static final long serialVersionUID = 1620489912540131959L;
    ILoggingTool logger = LoggingToolFactory.createLoggingTool(DebugReactionSet.class);

    @Override
    public void addListener(IChemObjectListener col) {
        this.logger.debug("Adding listener: ", col);
        super.addListener(col);
    }

    @Override
    public int getListenerCount() {
        this.logger.debug("Getting listener count: ", super.getListenerCount());
        return super.getListenerCount();
    }

    @Override
    public void removeListener(IChemObjectListener col) {
        this.logger.debug("Removing listener: ", col);
        super.removeListener(col);
    }

    @Override
    public void notifyChanged() {
        this.logger.debug("Notifying changed");
        super.notifyChanged();
    }

    @Override
    public void notifyChanged(IChemObjectChangeEvent evt) {
        this.logger.debug("Notifying changed event: ", evt);
        super.notifyChanged(evt);
    }

    @Override
    public void setProperty(Object description, Object property) {
        this.logger.debug("Setting property: ", description + "=" + property);
        super.setProperty(description, property);
    }

    @Override
    public void removeProperty(Object description) {
        this.logger.debug("Removing property: ", description);
        super.removeProperty(description);
    }

    @Override
    public <T> T getProperty(Object description) {
        this.logger.debug("Getting property: ", description + "=" + super.getProperty(description));
        return super.getProperty(description);
    }

    @Override
    public Map<Object, Object> getProperties() {
        this.logger.debug("Getting properties");
        return super.getProperties();
    }

    @Override
    public String getID() {
        this.logger.debug("Getting ID: ", super.getID());
        return super.getID();
    }

    @Override
    public void setID(String identifier) {
        this.logger.debug("Setting ID: ", identifier);
        super.setID(identifier);
    }

    @Override
    public void setFlag(int flag_type, boolean flag_value) {
        this.logger.debug("Setting flag: ", flag_type + "=" + flag_value);
        super.setFlag(flag_type, flag_value);
    }

    @Override
    public boolean getFlag(int flag_type) {
        this.logger.debug("Setting flag: ", flag_type + "=" + super.getFlag(flag_type));
        return super.getFlag(flag_type);
    }

    @Override
    public void addProperties(Map<Object, Object> properties) {
        this.logger.debug("Setting properties: ", properties);
        super.addProperties(properties);
    }

    @Override
    public void setFlags(boolean[] flagsNew) {
        this.logger.debug("Setting flags:", flagsNew.length);
        super.setFlags(flagsNew);
    }

    @Override
    public boolean[] getFlags() {
        this.logger.debug("Getting flags:", super.getFlags().length);
        return super.getFlags();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        Object clone = null;
        try {
            clone = super.clone();
        }
        catch (Exception exception) {
            this.logger.error("Could not clone DebugAtom: " + exception.getMessage(), exception);
            this.logger.debug(exception);
        }
        return clone;
    }

    @Override
    public IChemObjectBuilder getBuilder() {
        return DebugChemObjectBuilder.getInstance();
    }

    @Override
    public void addReaction(IReaction reaction) {
        this.logger.debug("Adding reaction: ", reaction);
        super.addReaction(reaction);
    }

    @Override
    public IReaction getReaction(int number) {
        this.logger.debug("Getting reaction at: ", number);
        return super.getReaction(number);
    }

    @Override
    public Iterable<IReaction> reactions() {
        this.logger.debug("Getting reactionIterable");
        return super.reactions();
    }

    @Override
    public int getReactionCount() {
        this.logger.debug("Getting reaction count: ", super.getReactionCount());
        return super.getReactionCount();
    }

    @Override
    public void removeAllReactions() {
        this.logger.debug("Removing all reactions");
        super.removeAllReactions();
    }

    @Override
    public void removeReaction(IReaction reaction) {
        this.logger.debug("Removing reaction " + reaction.getID());
        super.removeReaction(reaction);
    }

    @Override
    @TestMethod(value="testIsEmpty")
    public boolean isEmpty() {
        this.logger.debug("Checking if reaction set is empty: ", super.isEmpty());
        return super.isEmpty();
    }
}

