/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.generators;

import java.awt.Color;
import java.util.Collections;
import java.util.List;
import javax.vecmath.Point2d;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.geometry.GeometryTools;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.ILonePair;
import org.openscience.cdk.renderer.RendererModel;
import org.openscience.cdk.renderer.elements.ElementGroup;
import org.openscience.cdk.renderer.elements.IRenderingElement;
import org.openscience.cdk.renderer.elements.OvalElement;
import org.openscience.cdk.renderer.generators.BasicAtomGenerator;
import org.openscience.cdk.renderer.generators.BasicSceneGenerator;
import org.openscience.cdk.renderer.generators.IGenerator;
import org.openscience.cdk.renderer.generators.IGeneratorParameter;

@TestClass(value="org.openscience.cdk.renderer.generators.LonePairGeneratorTest")
public class LonePairGenerator
implements IGenerator<IAtomContainer> {
    @Override
    @TestMethod(value="testEmptyContainer")
    public IRenderingElement generate(IAtomContainer container, RendererModel model) {
        ElementGroup group = new ElementGroup();
        double SCREEN_RADIUS = 1.0;
        double SCREEN_SEPARATION = 2.5;
        Color RADICAL_COLOR = Color.BLACK;
        double ATOM_RADIUS = (Double)model.getParameter(BasicAtomGenerator.AtomRadius.class).getValue();
        double scale = (Double)model.getParameter(BasicSceneGenerator.Scale.class).getValue();
        double modelAtomRadius = ATOM_RADIUS / scale;
        double modelPointRadius = 1.0 / scale;
        double modelSeparation = 2.5 / scale;
        for (ILonePair lonePair : container.lonePairs()) {
            IAtom atom = lonePair.getAtom();
            Point2d point = atom.getPoint2d();
            int align = GeometryTools.getBestAlignmentForLabelXY(container, atom);
            double xRadius = point.x;
            double yRadius = point.y;
            double diffx = 0.0;
            double diffy = 0.0;
            if (align == 1) {
                xRadius += modelAtomRadius;
                diffy += modelSeparation;
            } else if (align == -1) {
                xRadius -= modelAtomRadius;
                diffy += modelSeparation;
            } else if (align == 2) {
                yRadius -= modelAtomRadius;
                diffx += modelSeparation;
            } else if (align == -2) {
                yRadius += modelAtomRadius;
                diffx += modelSeparation;
            }
            group.add(new OvalElement(xRadius + diffx, yRadius + diffy, modelPointRadius, true, RADICAL_COLOR));
            group.add(new OvalElement(xRadius - diffx, yRadius - diffy, modelPointRadius, true, RADICAL_COLOR));
        }
        return group;
    }

    @Override
    @TestMethod(value="testGetParameters")
    public List<IGeneratorParameter<?>> getParameters() {
        return Collections.emptyList();
    }
}

