/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.molecular;

import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.atomtype.CDKAtomTypeMatcher;
import org.openscience.cdk.config.Isotopes;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.descriptors.molecular.TPSADescriptor;
import org.openscience.cdk.qsar.result.DoubleResult;
import org.openscience.cdk.qsar.result.DoubleResultType;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.tools.CDKHydrogenAdder;
import org.openscience.cdk.tools.manipulator.AtomTypeManipulator;

@TestClass(value="org.openscience.cdk.qsar.descriptors.molecular.FractionalPSADescriptorTest")
public class FractionalPSADescriptor
implements IMolecularDescriptor {
    @TestMethod(value="nop")
    public void initialise(IChemObjectBuilder builder) {
    }

    @TestMethod(value="nop")
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#fractionalPSA", this.getClass().getName(), "The Chemistry Development Kit");
    }

    @TestMethod(value="nop")
    public void setParameters(Object[] params) throws CDKException {
        if (params.length != 0) {
            throw new CDKException("The FractionalPSADescriptor expects zero parameters");
        }
    }

    @TestMethod(value="nop")
    public Object[] getParameters() {
        return new Object[0];
    }

    @TestMethod(value="nop")
    public String[] getDescriptorNames() {
        return new String[]{"tpsaEfficiency"};
    }

    @TestMethod(value="nop")
    private DescriptorValue getDummyDescriptorValue(Exception e) {
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), (IDescriptorResult)new DoubleResult(Double.NaN), this.getDescriptorNames(), e);
    }

    @TestMethod(value="testDescriptors")
    public DescriptorValue calculate(IAtomContainer mol) {
        try {
            mol = mol.clone();
        }
        catch (CloneNotSupportedException ex) {
            // empty catch block
        }
        double polar = 0.0;
        double weight = 0.0;
        try {
            IChemObjectBuilder builder = mol.getBuilder();
            CDKAtomTypeMatcher matcher = CDKAtomTypeMatcher.getInstance((IChemObjectBuilder)builder);
            for (IAtom atom : mol.atoms()) {
                IAtomType type = matcher.findMatchingAtomType(mol, atom);
                AtomTypeManipulator.configure((IAtom)atom, (IAtomType)type);
            }
            CDKHydrogenAdder adder = CDKHydrogenAdder.getInstance((IChemObjectBuilder)builder);
            adder.addImplicitHydrogens(mol);
            TPSADescriptor tpsa = new TPSADescriptor();
            DescriptorValue value = tpsa.calculate(mol);
            polar = ((DoubleResult)value.getValue()).doubleValue();
            for (IAtom atom : mol.atoms()) {
                weight += Isotopes.getInstance().getMajorIsotope(atom.getSymbol()).getExactMass().doubleValue();
                Integer hcount = atom.getImplicitHydrogenCount();
                if (hcount == CDKConstants.UNSET) continue;
                weight += (double)hcount.intValue() * 1.00782504;
            }
        }
        catch (Exception exception) {
            return this.getDummyDescriptorValue(exception);
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), (IDescriptorResult)new DoubleResult(weight == 0.0 ? 0.0 : polar / weight), this.getDescriptorNames());
    }

    @TestMethod(value="nop")
    public IDescriptorResult getDescriptorResultType() {
        return new DoubleResultType();
    }

    @TestMethod(value="nop")
    public String[] getParameterNames() {
        return new String[0];
    }

    @TestMethod(value="nop")
    public Object getParameterType(String name) {
        return null;
    }
}

