/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.molecular;

import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.config.fragments.EStateFragments;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.qsar.AbstractMolecularDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.qsar.result.IntegerArrayResult;
import org.openscience.cdk.smiles.smarts.SMARTSQueryTool;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

@TestClass(value="org.openscience.cdk.qsar.descriptors.molecular.KierHallSmartsDescriptorTest")
public class KierHallSmartsDescriptor
extends AbstractMolecularDescriptor
implements IMolecularDescriptor {
    private static String[] names;
    private static final String[] smarts;

    public KierHallSmartsDescriptor() {
        String[] tmp = EStateFragments.getNames();
        names = new String[tmp.length];
        for (int i = 0; i < tmp.length; ++i) {
            KierHallSmartsDescriptor.names[i] = "khs." + tmp[i];
        }
    }

    @TestMethod(value="testGetSpecification")
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#kierHallSmarts", ((Object)((Object)this)).getClass().getName(), "The Chemistry Development Kit");
    }

    @TestMethod(value="testSetParameters_arrayObject")
    public void setParameters(Object[] params) throws CDKException {
        if (params != null) {
            throw new CDKException("Must not supply any parameters");
        }
    }

    @TestMethod(value="testGetParameters")
    public Object[] getParameters() {
        return null;
    }

    @TestMethod(value="testNamesConsistency")
    public String[] getDescriptorNames() {
        return names;
    }

    private DescriptorValue getDummyDescriptorValue(Exception e) {
        IntegerArrayResult result = new IntegerArrayResult();
        for (String smart : smarts) {
            result.add(0);
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), (IDescriptorResult)result, this.getDescriptorNames(), e);
    }

    @TestMethod(value="testCalculate_IAtomContainer")
    public DescriptorValue calculate(IAtomContainer container) {
        IAtomContainer atomContainer;
        if (container == null || container.getAtomCount() == 0) {
            return this.getDummyDescriptorValue((Exception)((Object)new CDKException("Container was null or else had no atoms")));
        }
        try {
            atomContainer = container.clone();
            atomContainer = AtomContainerManipulator.removeHydrogens((IAtomContainer)atomContainer);
        }
        catch (CloneNotSupportedException e) {
            return this.getDummyDescriptorValue((Exception)((Object)new CDKException("Error during clone")));
        }
        int[] counts = new int[smarts.length];
        try {
            SMARTSQueryTool sqt = new SMARTSQueryTool("C", container.getBuilder());
            for (int i = 0; i < smarts.length; ++i) {
                sqt.setSmarts(smarts[i]);
                boolean status = sqt.matches(atomContainer);
                counts[i] = status ? sqt.getUniqueMatchingAtoms().size() : 0;
            }
        }
        catch (CDKException e) {
            return this.getDummyDescriptorValue((Exception)((Object)e));
        }
        IntegerArrayResult result = new IntegerArrayResult();
        int[] arr$ = counts;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Integer i = arr$[i$];
            result.add(i.intValue());
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), (IDescriptorResult)result, this.getDescriptorNames());
    }

    @TestMethod(value="testGetDescriptorResultType")
    public IDescriptorResult getDescriptorResultType() {
        return new IntegerArrayResult(smarts.length);
    }

    @TestMethod(value="testGetParameterNames")
    public String[] getParameterNames() {
        return null;
    }

    @TestMethod(value="testGetParameterType_String")
    public Object getParameterType(String name) {
        return null;
    }

    static {
        smarts = EStateFragments.getSmarts();
    }
}

