/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.isomorphism.matchers.smarts;

import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.isomorphism.matchers.smarts.SMARTSAtom;

public class ImplicitHCountAtom
extends SMARTSAtom {
    private static final long serialVersionUID = 6752937431492584928L;

    public ImplicitHCountAtom(int hCount, IChemObjectBuilder builder) {
        super(builder);
        this.setImplicitHydrogenCount(hCount);
    }

    private int getIMPH(IAtom atom) {
        if (atom.getImplicitHydrogenCount() == CDKConstants.UNSET) {
            return 0;
        }
        return atom.getImplicitHydrogenCount();
    }

    @Override
    public boolean matches(IAtom atom) {
        return this.getIMPH(atom) != 0 && this.getIMPH(atom) == this.getIMPH((IAtom)this);
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("ImplicitHCountAtom(");
        s.append(((Object)((Object)this)).hashCode() + ", ");
        s.append("IH:" + this.getIMPH((IAtom)this));
        s.append(")");
        return s.toString();
    }
}

