/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.layout;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.vecmath.Point2d;
import javax.vecmath.Tuple2d;
import javax.vecmath.Vector2d;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.config.Elements;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.geometry.BondTools;
import org.openscience.cdk.geometry.GeometryTools;
import org.openscience.cdk.graph.PathTools;
import org.openscience.cdk.graph.matrix.ConnectionMatrix;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

@TestClass(value="org.openscience.cdk.layout.AtomPlacerTest")
public class AtomPlacer {
    public static final boolean debug = true;
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(AtomPlacer.class);
    IAtomContainer molecule = null;
    final Comparator<IAtom> ATOM_ORDER = new Comparator<IAtom>(){

        @Override
        public int compare(IAtom a, IAtom b) {
            return this.weight(a).compareTo(this.weight(b));
        }

        private Integer weight(IAtom atom) {
            Integer weight = (Integer)atom.getProperty((Object)"Weight");
            return weight != null ? weight : Integer.MIN_VALUE;
        }
    };

    @TestMethod(value="emptyAtomsListTest,triangleTest")
    public AtomPlacer() {
    }

    public IAtomContainer getMolecule() {
        return this.molecule;
    }

    public void setMolecule(IAtomContainer molecule) {
        this.molecule = molecule;
    }

    public void distributePartners(IAtom atom, IAtomContainer placedNeighbours, Point2d sharedAtomsCenter, IAtomContainer unplacedNeighbours, double bondLength) {
        double occupiedAngle = 0.0;
        IAtom[] sortedAtoms = null;
        double startAngle = 0.0;
        double addAngle = 0.0;
        double radius = 0.0;
        double remainingAngle = 0.0;
        Vector2d sharedAtomsCenterVector = new Vector2d((Tuple2d)sharedAtomsCenter);
        Vector2d newDirection = new Vector2d((Tuple2d)atom.getPoint2d());
        Vector2d occupiedDirection = new Vector2d((Tuple2d)sharedAtomsCenter);
        occupiedDirection.sub((Tuple2d)newDirection);
        logger.debug((Object)("distributePartners->occupiedDirection.lenght(): " + occupiedDirection.length()));
        ArrayList<IAtom> atomsToDraw = new ArrayList<IAtom>();
        logger.debug((Object)"Number of shared atoms: ", new Object[]{placedNeighbours.getAtomCount()});
        if (placedNeighbours.getAtomCount() == 1) {
            logger.debug((Object)"Only one neighbour...");
            for (int f = 0; f < unplacedNeighbours.getAtomCount(); ++f) {
                atomsToDraw.add(unplacedNeighbours.getAtom(f));
            }
            addAngle = Math.PI * 2 / (double)(unplacedNeighbours.getAtomCount() + placedNeighbours.getAtomCount());
            IAtom placedAtom = placedNeighbours.getAtom(0);
            double xDiff = placedAtom.getPoint2d().x - atom.getPoint2d().x;
            double yDiff = placedAtom.getPoint2d().y - atom.getPoint2d().y;
            logger.debug((Object)("distributePartners->xdiff: " + Math.toDegrees(xDiff)));
            logger.debug((Object)("distributePartners->ydiff: " + Math.toDegrees(yDiff)));
            startAngle = GeometryTools.getAngle((double)xDiff, (double)yDiff);
            logger.debug((Object)("distributePartners->angle: " + Math.toDegrees(startAngle)));
            this.populatePolygonCorners(atomsToDraw, new Point2d(atom.getPoint2d()), startAngle, addAngle, bondLength);
            return;
        }
        if (placedNeighbours.getAtomCount() == 0) {
            logger.debug((Object)"First atom...");
            for (int f = 0; f < unplacedNeighbours.getAtomCount(); ++f) {
                atomsToDraw.add(unplacedNeighbours.getAtom(f));
            }
            addAngle = Math.PI * 2 / (double)unplacedNeighbours.getAtomCount();
            startAngle = 0.0;
            this.populatePolygonCorners(atomsToDraw, new Point2d(atom.getPoint2d()), startAngle, addAngle, bondLength);
            return;
        }
        sharedAtomsCenterVector.sub((Tuple2d)newDirection);
        newDirection = sharedAtomsCenterVector;
        newDirection.normalize();
        newDirection.scale(bondLength);
        newDirection.negate();
        logger.debug((Object)("distributePartners->newDirection.lenght(): " + newDirection.length()));
        Point2d distanceMeasure = new Point2d(atom.getPoint2d());
        distanceMeasure.add((Tuple2d)newDirection);
        sortedAtoms = AtomContainerManipulator.getAtomArray((IAtomContainer)placedNeighbours);
        GeometryTools.sortBy2DDistance((IAtom[])sortedAtoms, (Point2d)distanceMeasure);
        Vector2d closestPoint1 = new Vector2d((Tuple2d)sortedAtoms[0].getPoint2d());
        Vector2d closestPoint2 = new Vector2d((Tuple2d)sortedAtoms[1].getPoint2d());
        closestPoint1.sub((Tuple2d)new Vector2d((Tuple2d)atom.getPoint2d()));
        closestPoint2.sub((Tuple2d)new Vector2d((Tuple2d)atom.getPoint2d()));
        occupiedAngle = closestPoint1.angle(occupiedDirection);
        occupiedAngle += closestPoint2.angle(occupiedDirection);
        double angle1 = GeometryTools.getAngle((double)(sortedAtoms[0].getPoint2d().x - atom.getPoint2d().x), (double)(sortedAtoms[0].getPoint2d().y - atom.getPoint2d().y));
        double angle2 = GeometryTools.getAngle((double)(sortedAtoms[1].getPoint2d().x - atom.getPoint2d().x), (double)(sortedAtoms[1].getPoint2d().y - atom.getPoint2d().y));
        double angle3 = GeometryTools.getAngle((double)(distanceMeasure.x - atom.getPoint2d().x), (double)(distanceMeasure.y - atom.getPoint2d().y));
        try {
            logger.debug((Object)"distributePartners->sortedAtoms[0]: ", new Object[]{this.molecule.getAtomNumber(sortedAtoms[0]) + 1});
            logger.debug((Object)"distributePartners->sortedAtoms[1]: ", new Object[]{this.molecule.getAtomNumber(sortedAtoms[1]) + 1});
            logger.debug((Object)"distributePartners->angle1: ", new Object[]{Math.toDegrees(angle1)});
            logger.debug((Object)"distributePartners->angle2: ", new Object[]{Math.toDegrees(angle2)});
        }
        catch (Exception exc) {
            logger.debug((Object)exc);
        }
        IAtom startAtom = null;
        startAtom = angle1 > angle3 ? (angle1 - angle3 < Math.PI ? sortedAtoms[1] : sortedAtoms[0]) : (angle3 - angle1 < Math.PI ? sortedAtoms[0] : sortedAtoms[1]);
        remainingAngle = Math.PI * 2 - occupiedAngle;
        addAngle = remainingAngle / (double)(unplacedNeighbours.getAtomCount() + 1);
        try {
            logger.debug((Object)("distributePartners->startAtom: " + (this.molecule.getAtomNumber(startAtom) + 1)));
            logger.debug((Object)("distributePartners->remainingAngle: " + Math.toDegrees(remainingAngle)));
            logger.debug((Object)("distributePartners->addAngle: " + Math.toDegrees(addAngle)));
            logger.debug((Object)("distributePartners-> partners.getAtomCount(): " + unplacedNeighbours.getAtomCount()));
        }
        catch (Exception exc) {
            logger.debug((Object)exc);
        }
        for (int f = 0; f < unplacedNeighbours.getAtomCount(); ++f) {
            atomsToDraw.add(unplacedNeighbours.getAtom(f));
        }
        radius = bondLength;
        startAngle = GeometryTools.getAngle((double)(startAtom.getPoint2d().x - atom.getPoint2d().x), (double)(startAtom.getPoint2d().y - atom.getPoint2d().y));
        logger.debug((Object)("Before check: distributePartners->startAngle: " + startAngle));
        logger.debug((Object)("After check: distributePartners->startAngle: " + startAngle));
        this.populatePolygonCorners(atomsToDraw, new Point2d(atom.getPoint2d()), startAngle, addAngle, radius);
    }

    public void placeLinearChain(IAtomContainer atomContainer, Vector2d initialBondVector, double bondLength) {
        IAtomContainer withh = (IAtomContainer)atomContainer.getBuilder().newInstance(IAtomContainer.class, new Object[]{atomContainer});
        int[] numh = new int[atomContainer.getAtomCount()];
        int n = atomContainer.getAtomCount();
        for (int i = 0; i < n; ++i) {
            Integer tmp = atomContainer.getAtom(i).getImplicitHydrogenCount();
            numh[i] = tmp == CDKConstants.UNSET ? 0 : tmp;
        }
        logger.debug((Object)("Placing linear chain of length " + atomContainer.getAtomCount()));
        Vector2d bondVector = initialBondVector;
        IAtom atom = null;
        Point2d atomPoint = null;
        IAtom nextAtom = null;
        IBond prevBond = null;
        IBond currBond = null;
        for (int f = 0; f < atomContainer.getAtomCount() - 1; ++f) {
            atom = atomContainer.getAtom(f);
            nextAtom = atomContainer.getAtom(f + 1);
            currBond = atomContainer.getBond(atom, nextAtom);
            atomPoint = new Point2d(atom.getPoint2d());
            bondVector.normalize();
            bondVector.scale(bondLength);
            atomPoint.add((Tuple2d)bondVector);
            nextAtom.setPoint2d(atomPoint);
            nextAtom.setFlag(1, true);
            boolean trans = false;
            if (prevBond != null && IBond.Order.DOUBLE.equals((Object)prevBond.getOrder()) && IBond.Order.DOUBLE.equals((Object)currBond.getOrder())) {
                int atomicNumber = atom.getAtomicNumber();
                int charge = atom.getFormalCharge();
                if (charge == 0 && (Elements.Carbon.number() == atomicNumber || Elements.Germanium.number() == atomicNumber || Elements.Silicon.number() == atomicNumber)) {
                    Point2d p = new Point2d(prevBond.getConnectedAtom(atom).getPoint2d());
                    p.interpolate((Tuple2d)atom.getPoint2d(), 2.0);
                    nextAtom.setPoint2d(p);
                }
            }
            if (GeometryTools.has2DCoordinates((IAtomContainer)atomContainer)) {
                try {
                    if (f > 2 && BondTools.isValidDoubleBondConfiguration((IAtomContainer)withh, (IBond)withh.getBond(withh.getAtom(f - 2), withh.getAtom(f - 1)))) {
                        trans = BondTools.isCisTrans((IAtom)withh.getAtom(f - 3), (IAtom)withh.getAtom(f - 2), (IAtom)withh.getAtom(f - 1), (IAtom)withh.getAtom(f - 0), (IAtomContainer)withh);
                    }
                }
                catch (Exception ex) {
                    logger.debug((Object)"Excpetion in detecting E/Z. This could mean that cleanup does not respect E/Z");
                }
                bondVector = this.getNextBondVector(nextAtom, atom, GeometryTools.get2DCenter((IAtomContainer)this.molecule), trans);
            } else {
                bondVector = this.getNextBondVector(nextAtom, atom, GeometryTools.get2DCenter((IAtomContainer)this.molecule), true);
            }
            prevBond = currBond;
        }
        int n2 = atomContainer.getAtomCount();
        for (int i = 0; i < n2; ++i) {
            atomContainer.getAtom(i).setImplicitHydrogenCount(Integer.valueOf(numh[i]));
        }
    }

    public Vector2d getNextBondVector(IAtom atom, IAtom previousAtom, Point2d distanceMeasure, boolean trans) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Entering AtomPlacer.getNextBondVector()");
            logger.debug((Object)("Arguments are atom: " + atom + ", previousAtom: " + previousAtom + ", distanceMeasure: " + distanceMeasure));
        }
        double angle = GeometryTools.getAngle((double)(previousAtom.getPoint2d().x - atom.getPoint2d().x), (double)(previousAtom.getPoint2d().y - atom.getPoint2d().y));
        double addAngle = Math.toRadians(120.0);
        if (!trans) {
            addAngle = Math.toRadians(60.0);
        }
        if (AtomPlacer.shouldBeLinear(atom, this.molecule)) {
            addAngle = Math.toRadians(180.0);
        }
        Vector2d vec1 = new Vector2d(Math.cos(angle += addAngle), Math.sin(angle));
        Point2d point1 = new Point2d(atom.getPoint2d());
        point1.add((Tuple2d)vec1);
        double distance1 = point1.distance(distanceMeasure);
        Vector2d vec2 = new Vector2d(Math.cos(angle += addAngle), Math.sin(angle));
        Point2d point2 = new Point2d(atom.getPoint2d());
        point2.add((Tuple2d)vec2);
        double distance2 = point2.distance(distanceMeasure);
        if (distance2 > distance1) {
            logger.debug((Object)"Exiting AtomPlacer.getNextBondVector()");
            return vec2;
        }
        logger.debug((Object)"Exiting AtomPlacer.getNextBondVector()");
        return vec1;
    }

    @TestMethod(value="emptyAtomsListTest,triangleTest")
    public void populatePolygonCorners(List<IAtom> atomsToDraw, Point2d rotationCenter, double startAngle, double addAngle, double radius) {
        int i;
        double angle = startAngle;
        logger.debug((Object)"populatePolygonCorners->startAngle: ", new Object[]{Math.toDegrees(angle)});
        ArrayList<Point2d> points = new ArrayList<Point2d>(atomsToDraw.size());
        logger.debug((Object)"  centerX:", new Object[]{rotationCenter.x});
        logger.debug((Object)"  centerY:", new Object[]{rotationCenter.y});
        logger.debug((Object)"  radius :", new Object[]{radius});
        for (i = 0; i < atomsToDraw.size(); ++i) {
            if ((angle += addAngle) >= Math.PI * 2) {
                angle -= Math.PI * 2;
            }
            logger.debug((Object)"populatePolygonCorners->angle: ", new Object[]{Math.toDegrees(angle)});
            double x = Math.cos(angle) * radius;
            double y = Math.sin(angle) * radius;
            double newX = x + rotationCenter.x;
            double newY = y + rotationCenter.y;
            logger.debug((Object)"  newX:", new Object[]{newX});
            logger.debug((Object)"  newY:", new Object[]{newY});
            points.add(new Point2d(newX, newY));
        }
        for (i = 0; i < atomsToDraw.size(); ++i) {
            IAtom connectAtom = atomsToDraw.get(i);
            connectAtom.setPoint2d((Point2d)points.get(i));
            connectAtom.setFlag(1, true);
            if (!logger.isDebugEnabled() || connectAtom == null) continue;
            try {
                logger.debug((Object)("populatePolygonCorners->connectAtom: " + (this.molecule.getAtomNumber(connectAtom) + 1) + " placed at " + connectAtom.getPoint2d()));
                continue;
            }
            catch (Exception exc) {
                // empty catch block
            }
        }
    }

    public void partitionPartners(IAtom atom, IAtomContainer unplacedPartners, IAtomContainer placedPartners) {
        List atoms = this.molecule.getConnectedAtomsList(atom);
        for (int i = 0; i < atoms.size(); ++i) {
            IAtom curatom = (IAtom)atoms.get(i);
            if (curatom.getFlag(1)) {
                placedPartners.addAtom(curatom);
                continue;
            }
            unplacedPartners.addAtom(curatom);
        }
    }

    public static IAtomContainer getInitialLongestChain(IAtomContainer molecule) throws CDKException {
        logger.debug((Object)"Start of getInitialLongestChain()");
        double[][] conMat = ConnectionMatrix.getMatrix((IAtomContainer)molecule);
        logger.debug((Object)"Computing all-pairs-shortest-pathes");
        int[][] apsp = PathTools.computeFloydAPSP((double[][])conMat);
        int maxPathLength = 0;
        int bestStartAtom = -1;
        int bestEndAtom = -1;
        IAtom atom = null;
        IAtom startAtom = null;
        for (int f = 0; f < apsp.length; ++f) {
            atom = molecule.getAtom(f);
            if (molecule.getConnectedBondsCount(atom) != 1) continue;
            for (int g = 0; g < apsp.length; ++g) {
                if (apsp[f][g] <= maxPathLength) continue;
                maxPathLength = apsp[f][g];
                bestStartAtom = f;
                bestEndAtom = g;
            }
        }
        logger.debug((Object)("Longest chaing in molecule is of length " + maxPathLength + " between atoms " + (bestStartAtom + 1) + " and " + (bestEndAtom + 1)));
        startAtom = molecule.getAtom(bestStartAtom);
        IAtomContainer path = (IAtomContainer)molecule.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        path.addAtom(startAtom);
        path = AtomPlacer.getLongestUnplacedChain(molecule, startAtom);
        logger.debug((Object)"End of getInitialLongestChain()");
        return path;
    }

    public static IAtomContainer getLongestUnplacedChain(IAtomContainer molecule, IAtom startAtom) throws CDKException {
        logger.debug((Object)"Start of getLongestUnplacedChain.");
        int longest = 0;
        int longestPathLength = 0;
        int maxDegreeSum = 0;
        int degreeSum = 0;
        IAtomContainer[] pathes = new IAtomContainer[molecule.getAtomCount()];
        for (int f = 0; f < molecule.getAtomCount(); ++f) {
            molecule.getAtom(f).setFlag(16, false);
            pathes[f] = (IAtomContainer)molecule.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
            pathes[f].addAtom(startAtom);
        }
        ArrayList<IAtom> startSphere = new ArrayList<IAtom>();
        startSphere.add(startAtom);
        AtomPlacer.breadthFirstSearch(molecule, startSphere, pathes);
        for (int f = 0; f < molecule.getAtomCount(); ++f) {
            if (pathes[f].getAtomCount() < longestPathLength || (degreeSum = AtomPlacer.getDegreeSum(pathes[f], molecule)) <= maxDegreeSum) continue;
            maxDegreeSum = degreeSum;
            longest = f;
            longestPathLength = pathes[f].getAtomCount();
        }
        logger.debug((Object)"End of getLongestUnplacedChain.");
        return pathes[longest];
    }

    public static void breadthFirstSearch(IAtomContainer ac, List<IAtom> sphere, IAtomContainer[] pathes) throws CDKException {
        int f;
        IAtom atom = null;
        IAtom nextAtom = null;
        ArrayList<IAtom> newSphere = new ArrayList<IAtom>();
        logger.debug((Object)"Start of breadthFirstSearch");
        for (f = 0; f < sphere.size(); ++f) {
            atom = sphere.get(f);
            if (atom.getFlag(2)) continue;
            int atomNr = ac.getAtomNumber(atom);
            logger.debug((Object)("BreadthFirstSearch around atom " + (atomNr + 1)));
            List bonds = ac.getConnectedBondsList(atom);
            for (int g = 0; g < bonds.size(); ++g) {
                IBond curBond = (IBond)bonds.get(g);
                nextAtom = curBond.getConnectedAtom(atom);
                if (nextAtom.getFlag(16) || nextAtom.getFlag(1)) continue;
                int nextAtomNr = ac.getAtomNumber(nextAtom);
                logger.debug((Object)("BreadthFirstSearch is meeting new atom " + (nextAtomNr + 1)));
                pathes[nextAtomNr] = (IAtomContainer)ac.getBuilder().newInstance(IAtomContainer.class, new Object[]{pathes[atomNr]});
                logger.debug((Object)("Making copy of path " + (atomNr + 1) + " to form new path " + (nextAtomNr + 1)));
                pathes[nextAtomNr].addAtom(nextAtom);
                logger.debug((Object)("Adding atom " + (nextAtomNr + 1) + " to path " + (nextAtomNr + 1)));
                pathes[nextAtomNr].addBond(curBond);
                if (ac.getConnectedBondsCount(nextAtom) <= 1) continue;
                newSphere.add(nextAtom);
            }
        }
        if (newSphere.size() > 0) {
            for (f = 0; f < newSphere.size(); ++f) {
                ((IAtom)newSphere.get(f)).setFlag(16, true);
            }
            AtomPlacer.breadthFirstSearch(ac, newSphere, pathes);
        }
        logger.debug((Object)"End of breadthFirstSearch");
    }

    public String listPlaced(IAtomContainer ac) {
        String s = "Placed: ";
        for (int f = 0; f < ac.getAtomCount(); ++f) {
            s = ac.getAtom(f).getFlag(1) ? s + (f + 1) + "+ " : s + (f + 1) + "- ";
        }
        return s;
    }

    public static String listNumbers(IAtomContainer mol, IAtomContainer ac) throws CDKException {
        String s = "Numbers: ";
        for (int f = 0; f < ac.getAtomCount(); ++f) {
            s = s + (mol.getAtomNumber(ac.getAtom(f)) + 1) + " ";
        }
        return s;
    }

    public static String listNumbers(IAtomContainer mol, List<IAtom> ac) throws Exception {
        String s = "Numbers: ";
        for (int f = 0; f < ac.size(); ++f) {
            s = s + (mol.getAtomNumber(ac.get(f)) + 1) + " ";
        }
        return s;
    }

    public static boolean allPlaced(IAtomContainer ac) {
        for (int f = 0; f < ac.getAtomCount(); ++f) {
            if (ac.getAtom(f).getFlag(1)) continue;
            return false;
        }
        return true;
    }

    public static void markNotPlaced(IAtomContainer ac) {
        for (int f = 0; f < ac.getAtomCount(); ++f) {
            ac.getAtom(f).setFlag(1, false);
        }
    }

    public static void markPlaced(IAtomContainer ac) {
        for (int f = 0; f < ac.getAtomCount(); ++f) {
            ac.getAtom(f).setFlag(1, true);
        }
    }

    public static IAtomContainer getPlacedAtoms(IAtomContainer ac) {
        IAtomContainer ret = (IAtomContainer)ac.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        for (int f = 0; f < ac.getAtomCount(); ++f) {
            if (!ac.getAtom(f).getFlag(1)) continue;
            ret.addAtom(ac.getAtom(f));
        }
        return ret;
    }

    static int getDegreeSum(IAtomContainer ac, IAtomContainer superAC) {
        int degreeSum = 0;
        for (int f = 0; f < ac.getAtomCount(); ++f) {
            degreeSum += superAC.getConnectedBondsCount(ac.getAtom(f));
        }
        return degreeSum;
    }

    static void calculateWeights(IAtomContainer ac) {
        int[] weights = AtomPlacer.getWeightNumbers(ac);
        for (int f = 0; f < ac.getAtomCount(); ++f) {
            ac.getAtom(f).setProperty((Object)"Weight", (Object)weights[f]);
        }
    }

    static int[] getWeightNumbers(IAtomContainer atomContainer) {
        int N = atomContainer.getAtomCount();
        int[] morganMatrix = new int[N];
        int[] tempMorganMatrix = new int[N];
        List atoms = null;
        for (int f = 0; f < N; ++f) {
            morganMatrix[f] = atomContainer.getConnectedBondsCount(f);
            tempMorganMatrix[f] = atomContainer.getConnectedBondsCount(f);
        }
        for (int e = 0; e < N; ++e) {
            for (int f = 0; f < N; ++f) {
                morganMatrix[f] = 0;
                atoms = atomContainer.getConnectedAtomsList(atomContainer.getAtom(f));
                for (int g = 0; g < atoms.size(); ++g) {
                    IAtom atom = (IAtom)atoms.get(g);
                    if (atom.getFlag(1)) continue;
                    int n = f;
                    morganMatrix[n] = morganMatrix[n] + tempMorganMatrix[atomContainer.getAtomNumber(atom)];
                }
            }
            System.arraycopy(morganMatrix, 0, tempMorganMatrix, 0, N);
        }
        return tempMorganMatrix;
    }

    public static boolean shouldBeLinear(IAtom atom, IAtomContainer molecule) {
        int sum = 0;
        List bonds = molecule.getConnectedBondsList(atom);
        for (int g = 0; g < bonds.size(); ++g) {
            IBond bond = (IBond)bonds.get(g);
            if (bond.getOrder() == IBond.Order.TRIPLE) {
                sum += 10;
                continue;
            }
            if (bond.getOrder() != IBond.Order.SINGLE) continue;
            ++sum;
        }
        return sum >= 10;
    }
}

