/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.isomorphism.matchers;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IChemObjectChangeEvent;
import org.openscience.cdk.interfaces.IChemObjectListener;

public class QueryChemObject
implements IChemObject {
    private List<IChemObjectListener> chemObjectListeners = null;
    private Map<Object, Object> properties = null;
    private String identifier = null;
    private short flags;
    private final IChemObjectBuilder builder;
    private boolean doNotification = true;

    public QueryChemObject(IChemObjectBuilder builder) {
        this.builder = builder;
    }

    private List<IChemObjectListener> lazyChemObjectListeners() {
        if (this.chemObjectListeners == null) {
            this.chemObjectListeners = new ArrayList<IChemObjectListener>();
        }
        return this.chemObjectListeners;
    }

    @Override
    public void addListener(IChemObjectListener col) {
        List<IChemObjectListener> listeners = this.lazyChemObjectListeners();
        if (!listeners.contains(col)) {
            listeners.add(col);
        }
    }

    @Override
    public int getListenerCount() {
        if (this.chemObjectListeners == null) {
            return 0;
        }
        return this.lazyChemObjectListeners().size();
    }

    @Override
    public void removeListener(IChemObjectListener col) {
        if (this.chemObjectListeners == null) {
            return;
        }
        List<IChemObjectListener> listeners = this.lazyChemObjectListeners();
        if (listeners.contains(col)) {
            listeners.remove(col);
        }
    }

    @Override
    public void notifyChanged() {
        if (this.getNotification() && this.getListenerCount() > 0) {
            List<IChemObjectListener> listeners = this.lazyChemObjectListeners();
            for (IChemObjectListener listener : listeners) {
                listener.stateChanged(new QueryChemObjectChangeEvent(this));
            }
        }
    }

    @Override
    public void notifyChanged(IChemObjectChangeEvent evt) {
        if (this.getNotification() && this.getListenerCount() > 0) {
            List<IChemObjectListener> listeners = this.lazyChemObjectListeners();
            for (IChemObjectListener listener : listeners) {
                listener.stateChanged(evt);
            }
        }
    }

    private Map<Object, Object> lazyProperties() {
        if (this.properties == null) {
            this.properties = new HashMap<Object, Object>();
        }
        return this.properties;
    }

    @Override
    public void setProperty(Object description, Object property) {
        this.lazyProperties().put(description, property);
        this.notifyChanged();
    }

    @Override
    public void removeProperty(Object description) {
        if (this.properties == null) {
            return;
        }
        if (this.lazyProperties().remove(description) != null) {
            this.notifyChanged();
        }
    }

    @Override
    public <T> T getProperty(Object description) {
        Object value = this.lazyProperties().get(description);
        return (T)value;
    }

    @Override
    public <T> T getProperty(Object description, Class<T> c) {
        Object value = this.lazyProperties().get(description);
        if (c.isInstance(value)) {
            Object typed = value;
            return (T)typed;
        }
        if (value != null) {
            throw new IllegalArgumentException("attempted to access a property of incorrect type, expected " + c.getSimpleName() + " got " + value.getClass().getSimpleName());
        }
        return null;
    }

    @Override
    public Map<Object, Object> getProperties() {
        return this.lazyProperties();
    }

    @Override
    public String getID() {
        return this.identifier;
    }

    @Override
    public void setID(String identifier) {
        this.identifier = identifier;
        this.notifyChanged();
    }

    @Override
    public void setFlag(int mask, boolean value) {
        this.flags = value ? (short)(this.flags | mask) : (short)(this.flags & ~mask);
        this.notifyChanged();
    }

    @Override
    public boolean getFlag(int mask) {
        return (this.flags & mask) != 0;
    }

    @Override
    public void setProperties(Map<Object, Object> properties) {
        this.properties = null;
        if (properties != null) {
            this.addProperties(properties);
        }
    }

    @Override
    public void addProperties(Map<Object, Object> properties) {
        if (properties == null) {
            return;
        }
        this.lazyProperties().putAll(properties);
        this.notifyChanged();
    }

    @Override
    public void setFlags(boolean[] flagsNew) {
        for (int i = 0; i < flagsNew.length; ++i) {
            this.setFlag(CDKConstants.FLAG_MASKS[i], flagsNew[i]);
        }
    }

    @Override
    public boolean[] getFlags() {
        boolean[] flagArray = new boolean[14];
        for (int i = 0; i < CDKConstants.FLAG_MASKS.length; ++i) {
            int mask = CDKConstants.FLAG_MASKS[i];
            flagArray[i] = this.getFlag(mask);
        }
        return flagArray;
    }

    @Override
    public Short getFlagValue() {
        return this.flags;
    }

    @Override
    public void setNotification(boolean bool) {
        this.doNotification = bool;
    }

    @Override
    public boolean getNotification() {
        return this.doNotification;
    }

    @Override
    public IChemObjectBuilder getBuilder() {
        return this.builder;
    }

    public boolean matches(IAtom atom) {
        return false;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    class QueryChemObjectChangeEvent
    extends EventObject
    implements IChemObjectChangeEvent {
        private static final long serialVersionUID = 8060005185140623245L;

        public QueryChemObjectChangeEvent(Object source) {
            super(source);
        }
    }
}

