/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smiles;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.openscience.cdk.smiles.CxSmilesState;
import org.openscience.cdk.smiles.SmiFlavor;

public class CxSmilesGenerator {
    private static int[] inverse(int[] perm) {
        int[] inv = new int[perm.length];
        int len = perm.length;
        for (int i = 0; i < len; ++i) {
            inv[perm[i]] = i;
        }
        return inv;
    }

    private static String encode_alias(String label) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < label.length(); ++i) {
            char c = label.charAt(i);
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '_') {
                sb.append(c);
                continue;
            }
            sb.append("&#").append(Integer.toString(c)).append(";");
        }
        return sb.toString();
    }

    private static int compare(Comparator<Integer> comp, List<Integer> a, List<Integer> b) {
        int alen = a.size();
        int blen = b.size();
        int len = Math.min(alen, blen);
        for (int i = 0; i < len; ++i) {
            int cmp = comp.compare(a.get(i), b.get(i));
            if (cmp == 0) continue;
            return cmp;
        }
        return Integer.compare(alen, blen);
    }

    /*
     * WARNING - void declaration
     */
    static String generate(CxSmilesState state, int opts, int[] components, final int[] ordering) {
        int nonempty_cnt;
        if (!SmiFlavor.isSet(opts, 2076672)) {
            return "";
        }
        final int[] invorder = CxSmilesGenerator.inverse(ordering);
        StringBuilder sb = new StringBuilder();
        sb.append(' ');
        sb.append('|');
        Comparator<Integer> invComp = new Comparator<Integer>(){

            @Override
            public int compare(Integer a, Integer b) {
                return Integer.compare(invorder[a], invorder[b]);
            }
        };
        final Comparator<Integer> comp = new Comparator<Integer>(){

            @Override
            public int compare(Integer a, Integer b) {
                return Integer.compare(ordering[a], ordering[b]);
            }
        };
        if (SmiFlavor.isSet(opts, 0x100000) && state.fragGroups != null && !state.fragGroups.isEmpty()) {
            int maxCompId = 0;
            for (int compId : components) {
                if (compId <= maxCompId) continue;
                maxCompId = compId;
            }
            final int[] compMap = new int[maxCompId + 1];
            boolean bl = true;
            for (int n : invorder) {
                void var10_21;
                int component = components[n];
                if (compMap[component] != 0) continue;
                compMap[component] = ++var10_21;
            }
            int i = 0;
            while (i < compMap.length) {
                int n = i++;
                compMap[n] = compMap[n] - 1;
            }
            final Comparator<Integer> compComp = new Comparator<Integer>(){

                @Override
                public int compare(Integer a, Integer b) {
                    return Integer.compare(compMap[a], compMap[b]);
                }
            };
            ArrayList<List<Integer>> fragGroupCpy = new ArrayList<List<Integer>>(state.fragGroups);
            for (List list : fragGroupCpy) {
                Collections.sort(list, compComp);
            }
            Collections.sort(fragGroupCpy, new Comparator<List<Integer>>(){

                @Override
                public int compare(List<Integer> a, List<Integer> b) {
                    return CxSmilesGenerator.compare(compComp, a, b);
                }
            });
            sb.append('f');
            sb.append(':');
            for (int i2 = 0; i2 < fragGroupCpy.size(); ++i2) {
                if (i2 > 0) {
                    sb.append(',');
                }
                CxSmilesGenerator.appendIntegers(compMap, '.', sb, (List)fragGroupCpy.get(i2));
            }
        }
        if (SmiFlavor.isSet(opts, 32768) && state.atomLabels != null && !state.atomLabels.isEmpty()) {
            if (sb.length() > 2) {
                sb.append(',');
            }
            sb.append('$');
            nonempty_cnt = 0;
            for (int idx : invorder) {
                String label = state.atomLabels.get(idx);
                if (label == null || label.isEmpty()) {
                    label = "";
                } else {
                    ++nonempty_cnt;
                }
                sb.append(CxSmilesGenerator.encode_alias(label));
                if (nonempty_cnt == state.atomLabels.size()) break;
                sb.append(";");
            }
            sb.append('$');
        }
        if (SmiFlavor.isSet(opts, 65536) && state.atomValues != null && !state.atomValues.isEmpty()) {
            if (sb.length() > 2) {
                sb.append(',');
            }
            sb.append("$_AV:");
            nonempty_cnt = 0;
            for (int idx : invorder) {
                String label = state.atomValues.get(idx);
                if (label == null || label.isEmpty()) {
                    label = "";
                } else {
                    ++nonempty_cnt;
                }
                sb.append(CxSmilesGenerator.encode_alias(label));
                if (nonempty_cnt == state.atomValues.size()) break;
                sb.append(";");
            }
            sb.append('$');
        }
        if (SmiFlavor.isSet(opts, 12288) && state.atomCoords != null && !state.atomCoords.isEmpty()) {
            DecimalFormat fmt = new DecimalFormat("#.##");
            if (sb.length() > 2) {
                sb.append(',');
            }
            sb.append('(');
            for (int i = 0; i < ordering.length; ++i) {
                double[] dArray = state.atomCoords.get(invorder[i]);
                if (i != 0) {
                    sb.append(';');
                }
                if (dArray[0] != 0.0) {
                    sb.append(fmt.format(dArray[0]));
                }
                sb.append(',');
                if (dArray[1] != 0.0) {
                    sb.append(fmt.format(dArray[1]));
                }
                sb.append(',');
                if (dArray[2] == 0.0) continue;
                sb.append(fmt.format(dArray[2]));
            }
            sb.append(')');
        }
        if (SmiFlavor.isSet(opts, 262144) && state.positionVar != null && !state.positionVar.isEmpty()) {
            if (sb.length() > 2) {
                sb.append(',');
            }
            sb.append('m');
            sb.append(':');
            ArrayList<Map.Entry<Integer, List<Integer>>> multicenters = new ArrayList<Map.Entry<Integer, List<Integer>>>(state.positionVar.entrySet());
            Collections.sort(multicenters, new Comparator<Map.Entry<Integer, List<Integer>>>(){

                @Override
                public int compare(Map.Entry<Integer, List<Integer>> a, Map.Entry<Integer, List<Integer>> b) {
                    return comp.compare(a.getKey(), b.getKey());
                }
            });
            for (int i = 0; i < multicenters.size(); ++i) {
                if (i != 0) {
                    sb.append(',');
                }
                Map.Entry entry = (Map.Entry)multicenters.get(i);
                sb.append(ordering[(Integer)entry.getKey()]);
                sb.append(':');
                ArrayList<Integer> vals = new ArrayList<Integer>((Collection)entry.getValue());
                Collections.sort(vals, comp);
                CxSmilesGenerator.appendIntegers(ordering, '.', sb, vals);
            }
        }
        if (SmiFlavor.isSet(opts, 524288) && state.sgroups != null && !state.sgroups.isEmpty()) {
            ArrayList<CxSmilesState.PolymerSgroup> sgroups = new ArrayList<CxSmilesState.PolymerSgroup>(state.sgroups);
            for (CxSmilesState.PolymerSgroup polymerSgroup : sgroups) {
                Collections.sort(polymerSgroup.atomset, comp);
            }
            Collections.sort(sgroups, new Comparator<CxSmilesState.PolymerSgroup>(){

                @Override
                public int compare(CxSmilesState.PolymerSgroup a, CxSmilesState.PolymerSgroup b) {
                    int cmp = 0;
                    cmp = a.type.compareTo(b.type);
                    if (cmp != 0) {
                        return cmp;
                    }
                    cmp = CxSmilesGenerator.compare(comp, a.atomset, b.atomset);
                    return cmp;
                }
            });
            for (int i = 0; i < sgroups.size(); ++i) {
                if (sb.length() > 2) {
                    sb.append(',');
                }
                sb.append("Sg:");
                CxSmilesState.PolymerSgroup polymerSgroup = (CxSmilesState.PolymerSgroup)sgroups.get(i);
                sb.append(polymerSgroup.type);
                sb.append(':');
                CxSmilesGenerator.appendIntegers(ordering, ',', sb, polymerSgroup.atomset);
                sb.append(':');
                if (polymerSgroup.subscript != null) {
                    sb.append(polymerSgroup.subscript);
                }
                sb.append(':');
                if (polymerSgroup.supscript == null) continue;
                sb.append(polymerSgroup.supscript.toLowerCase(Locale.ROOT));
            }
        }
        if (SmiFlavor.isSet(opts, 131072) && state.atomRads != null && !state.atomRads.isEmpty()) {
            TreeMap<CxSmilesState.Radical, ArrayList<Integer>> radinv = new TreeMap<CxSmilesState.Radical, ArrayList<Integer>>();
            for (Map.Entry<Integer, CxSmilesState.Radical> entry : state.atomRads.entrySet()) {
                ArrayList<Integer> idxs = (ArrayList<Integer>)radinv.get((Object)entry.getValue());
                if (idxs == null) {
                    idxs = new ArrayList<Integer>();
                    radinv.put(entry.getValue(), idxs);
                }
                idxs.add(entry.getKey());
            }
            for (Map.Entry<Integer, CxSmilesState.Radical> entry : radinv.entrySet()) {
                if (sb.length() > 2) {
                    sb.append(',');
                }
                sb.append('^');
                sb.append(((CxSmilesState.Radical)((Object)entry.getKey())).ordinal() + 1);
                sb.append(':');
                Collections.sort((List)((Object)entry.getValue()), comp);
                CxSmilesGenerator.appendIntegers(ordering, ',', sb, (List)((Object)entry.getValue()));
            }
        }
        sb.append('|');
        if (sb.length() <= 3) {
            return "";
        }
        return sb.toString();
    }

    private static void appendIntegers(int[] invorder, char sep, StringBuilder sb, List<Integer> vals) {
        Iterator<Integer> iter = vals.iterator();
        if (iter.hasNext()) {
            sb.append(invorder[iter.next()]);
            while (iter.hasNext()) {
                sb.append(sep);
                sb.append(invorder[iter.next()]);
            }
        }
    }
}

