% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwiseNominalIndependence.r
\name{pairwiseNominalIndependence}
\alias{pairwiseNominalIndependence}
\title{Pairwise tests of independence for nominal data}
\usage{
pairwiseNominalIndependence(x, compare = "row", fisher = TRUE,
  gtest = TRUE, chisq = TRUE, method = "fdr", correct = "none",
  digits = 3, ...)
}
\arguments{
\item{x}{A two-way contingency table. At least one dimension should have
more than two levels.}

\item{compare}{If \code{"row"}, treats the rows as the grouping variable.
If \code{"column"}, treats the columns as the grouping variable.}

\item{fisher}{If \code{"TRUE"}, conducts fisher exact test.}

\item{gtest}{If \code{"TRUE"}, conducts G-test.}

\item{chisq}{If \code{"TRUE"}, conducts Chi-square test of association.}

\item{method}{The method to adjust multiple p-values. 
See \code{\link{p.adjust}}.}

\item{correct}{The correction method to pass to \code{GTest}
See \code{\link{GTest}}.}

\item{digits}{The number of significant digits in the output.}

\item{...}{Additional arguments, passed to \code{\link{fisher.test}}, 
\code{\link{GTest}}, or \code{\link{chisq.test}}.}
}
\value{
A data frame of comparisons, p-values, and adjusted p-values.
        
 @seealso \code{\link{pairwiseMcnemar}}, \code{\link{groupwiseCMH}},
          \code{\link{nominalSymmetryTest}}, 
          \code{\link{pairwiseNominalMatrix}}
}
\description{
Conducts pairwise tests for a 2-dimensional matrix,
             in which at at least one dimension has more than two
             levels, as a post-hoc test. Conducts Fisher exact, Chi-square,
             or G-test.
}
\details{
(None.)
}
\examples{
### Independence test for a 4 x 2 matrix
data(Anderson)
fisher.test(Anderson)
pairwiseNominalIndependence(Anderson)
                                                              
}
\author{
Salvatore Mangiafico, \email{mangiafico@njaes.rutgers.edu}
}
\references{
\url{http://rcompanion.org/handbook/H_04.html}
}
\concept{
Chi-square G-test Fisher contingency table nominal
}

