% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwiseSignMatrix.r
\name{pairwiseSignMatrix}
\alias{pairwiseSignMatrix}
\title{Pairwise sign tests for paired data with matrix output}
\usage{
pairwiseSignMatrix(x, g, method = "fdr", ...)
}
\arguments{
\item{x}{The response variable as a vector.}

\item{g}{The grouping variable as a vector.}

\item{method}{The p-value adjustment method to use for multiple tests.
See \code{\link{p.adjust}}.}

\item{...}{Additional arguments passed to
\code{\link{SIGN.test}}.}
}
\value{
A list consisting of:
        A matrix of p-values;
        the p-value adjustment method;
        a matrix of adjusted p-values.
}
\description{
Conducts pairwise sign tests across groups
             for paired data.
}
\details{
The two sample paired sign test compares medians 
         among two groups with paired data.
         See \url{http://rcompanion.org/handbook/F_07.html} for
         futher discussion of this test.

         The \code{pairwiseSignTest} function
         can be used as a post-hoc method following an omnibus
         Friedman test.
         The matrix output can be converted to a compact letter display.
         
         The function assumes that the data frame is already ordered by
         the blocking variable, so that the first observation of Group 1
         is paired with the first observation of Group 2, and so on.
}
\examples{
data(BobBelcher)
friedman.test(Likert ~ Instructor | Rater,
              data = BobBelcher)
BobBelcher = BobBelcher[order(factor(BobBelcher$Instructor, 
                        levels=c("Linda Belcher", "Louise Belcher",
                                 "Tina Belcher", "Bob Belcher",
                                 "Gene Belcher"))),]             
PT = pairwiseSignMatrix(x      = BobBelcher$Likert,
                        g      = BobBelcher$Instructor,
                        method = "fdr")$Adjusted
PT
library(multcompView)
multcompLetters(PT,
                compare="<",
                threshold=0.05,
                Letters=letters)
                 
}
\author{
Salvatore Mangiafico, \email{mangiafico@njaes.rutgers.edu}
}
\references{
\url{http://rcompanion.org/handbook/F_10.html}
}
\seealso{
\code{\link{pairwiseSignTest}}
}
\concept{
median nonparametric post-hoc paired Friedman unreplicated cld
}

