% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groupwiseMean.r
\name{groupwiseMean}
\alias{groupwiseMean}
\title{Groupwise means and confidence intervals}
\usage{
groupwiseMean(data, group, var, conf = 0.95, R = 5000, boot = FALSE,
  traditional = TRUE, normal = FALSE, basic = FALSE, percentile = FALSE,
  bca = FALSE, digits = 3, ...)
}
\arguments{
\item{data}{The data frame to use.}

\item{group}{The grouping variable to use. The name is in double quotes.
Multiple names are listed as a vector. (See example.)}

\item{var}{The measurement variable to use. The name is in double quotes.}

\item{conf}{The confidence interval to use.}

\item{R}{The number of bootstrap replicates to use for bootstrapped
statistics.}

\item{boot}{If \code{TRUE}, includes the mean of the bootstrapped means.
This can be used as an estimate of the mean for
the group.}

\item{traditional}{If \code{TRUE}, includes the traditional confidence
intervals for the group means, using the t-distribution.}

\item{normal}{If \code{TRUE}, includes the normal confidence
intervals for the group means by bootstrap.
See \code{\link{boot.ci}}.}

\item{basic}{If \code{TRUE}, includes the basic confidence
intervals for the group means by bootstrap.
See \code{\link{boot.ci}}.}

\item{percentile}{If \code{TRUE}, includes the percentile confidence
intervals for the group means by bootstrap.
See \code{\link{boot.ci}}.}

\item{bca}{If \code{TRUE}, includes the BCa confidence
intervals for the group means by bootstrap.
See \code{\link{boot.ci}}.}

\item{digits}{The number of significant figures to use in output.}

\item{...}{Other arguments passed to the \code{boot} function.}
}
\value{
A data frame of requested statistics by group.
}
\description{
Calculates means and confidence intervals for
             groups.
}
\details{
With some options, the function may not handle missing values well.
         This seems to happen particularly with \code{bca = TRUE}.
}
\examples{
data(Catbus)
groupwiseMean(data        = Catbus,
              var         = "Steps",
              group       = c("Teacher", "Sex"),
              traditional = FALSE,
              percentile  = TRUE)
                      
}
\author{
Salvatore Mangiafico, \email{mangiafico@njaes.rutgers.edu}
}
\references{
\url{http://rcompanion.org/handbook/C_03.html}
}
\seealso{
\code{\link{groupwiseMedian}}, \code{\link{groupwiseHuber}}
         \code{\link{groupwiseGeometric}}
}
\concept{
mean confidence interval bootstrap
}

