% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwisePermutationMatrix.r
\name{pairwisePermutationMatrix}
\alias{pairwisePermutationMatrix}
\title{Pairwise two-sample permutation tests with matrix output}
\usage{
pairwisePermutationMatrix(formula = NULL, data = NULL, x = NULL,
  g = NULL, method = "fdr", ...)
}
\arguments{
\item{formula}{A formula indicating the measurement variable and
the grouping variable. e.g. y ~ group.}

\item{data}{The data frame to use.}

\item{x}{The response variable as a vector.}

\item{g}{The grouping variable as a vector.}

\item{method}{The p-value adjustment method to use for multiple tests.
See \code{\link{p.adjust}}.}

\item{...}{Additional arguments passed to
\code{\link{independence_test}}.}
}
\value{
A list consisting of:
        A matrix of p-values;
        the p-value adjustment method;
        a matrix of adjusted p-values.
}
\description{
Conducts pairwise two-sample permutation tests across groups.
}
\details{
The input should include either \code{formula} and \code{data};
         or \code{x}, and \code{g}.

         Permutation tests are non-parametric tests 
         that do not assume normally-distributed errors.
         See \url{http://rcompanion.org/rcompanion/d_06a.html} for
         futher discussion of this test.

         The \code{pairwisePermutationTest} function
         can be used as a post-hoc method following an omnibus 
         permutation test analogous to a one-way analysis
         of variance.
         The matrix output can be converted to a compact letter display.
}
\note{
The parsing of the formula is simplistic. 
         The first variable on the
         left side is used as the measurement variable.  
         The first variable on the
         right side is used for the grouping variable.
}
\examples{
data(PoohPiglet)
PoohPiglet$Speaker = factor(PoohPiglet$Speaker,
                     levels = c("Pooh", "Tigger", "Piglet"))            
PT = pairwisePermutationMatrix(Likert ~ Speaker,
                               data   = PoohPiglet,
                               method = "fdr")
PT
PT = PT$Adjusted
library(multcompView)
multcompLetters(PT,
                compare="<",
                threshold=0.05,
                Letters=letters)   

}
\references{
\url{http://rcompanion.org/handbook/K_02.html}
}
\seealso{
\code{\link{pairwisePermutationTest}}
}
\author{
Salvatore Mangiafico, \email{mangiafico@njaes.rutgers.edu}
}
\concept{
permutation nonparametric post-hoc one-way cld
}
