% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cramerV.r
\name{cramerV}
\alias{cramerV}
\title{Cramer V}
\usage{
cramerV(x, y = NULL, digits = 4, bias.correct = FALSE)
}
\arguments{
\item{x}{Either a two-way table or a two-way matrix.
Can also be a vector of observations for one dimension
of a two-way table.}

\item{y}{If \code{x} is a vector, \code{y} is the vector of observations for
the second dimension of a two-way table.}

\item{digits}{The number of significant digits in the output.}

\item{bias.correct}{If \code{TRUE}, a bias correction is applied.}
}
\value{
A single statistic, Cramer's V.
}
\description{
Calculates Cramer's V for a table of nominal variables.
}
\details{
Cramer's V is used as a measure of association
          between two nominal variables, or as an effect size
          for a chi-square test of association.  For a 2 x 2 table,
          the absolute value of the phi statistic is the same as
          Cramer's V.
}
\examples{
data(Anderson)
fisher.test(Anderson)
cramerV(Anderson)

}
\references{
\url{http://rcompanion.org/handbook/H_10.html}
}
\author{
Salvatore Mangiafico, \email{mangiafico@njaes.rutgers.edu}
}
\concept{
correlation phi cramer V
}
