% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wilcoxonOneSampleR.r
\name{wilcoxonOneSampleR}
\alias{wilcoxonOneSampleR}
\title{r effect size for Wilcoxon one-sample signed-rank test}
\usage{
wilcoxonOneSampleR(x, mu = NULL, ci = FALSE, conf = 0.95,
  type = "perc", R = 1000, histogram = FALSE, digits = 3, ...)
}
\arguments{
\item{x}{A vector of observations of an ordinal variable.}

\item{mu}{The value to compare \code{x} to, as in \code{wilcox.test}}

\item{ci}{If \code{TRUE}, returns confidence intervals by bootstrap.
May be slow.}

\item{conf}{The level for the confidence interval.}

\item{type}{The type of confidence interval to use.
Can be any of "\code{norm}", "\code{basic}", 
              "\code{perc}", or "\code{bca}".
Passed to \code{boot.ci}.}

\item{R}{The number of replications to use for bootstrap.}

\item{histogram}{If \code{TRUE}, produces a histogram of bootstrapped values.}

\item{digits}{The number of significant digits in the output.}

\item{...}{Additional arguments passed to the \code{wilcoxsign_test} function.}
}
\value{
A single statistic, r.
        Or a small data frame consisting of r,
        and the lower and upper confidence limits.
}
\description{
Calculates r effect size
             for a Wilcoxon one-sample signed-rank test; confidence intervals
             by bootstap.
}
\details{
A Z value is extracted from the \code{wilcoxsign_test} function in the
          coin package.  r  is calculated as Z divided by 
          square root of the number of observations.
          
          The calculated statistic is equivalent to the statistic returned
          by the \code{wilcoxPairedR} function with one group equal
          to a vector of \code{mu}.
          The author knows of no reference for this technique.
          
          Currently, the function makes no provisions for \code{NA}
          values in the data.  It is recommended that \code{NA}s be removed
          beforehand.
          
          When r is close to 0 or very large,
          or with small counts in some cells,
          the confidence intervals 
          determined by this
          method may not be reliable, or the procedure may fail.
}
\examples{
data(Pooh)
Data = Pooh[Pooh$Time==2,]
wilcox.test(Data$Likert, mu=3, exact=FALSE)
wilcoxonOneSampleR(x = Data$Likert, mu=3)

}
\references{
\url{http://rcompanion.org/handbook/F_02.html}
}
\author{
Salvatore Mangiafico, \email{mangiafico@njaes.rutgers.edu}
}
\concept{effect size ordinal nominal}
