% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groupwiseCMH.r
\name{groupwiseCMH}
\alias{groupwiseCMH}
\title{Post-hoc tests for Cochran-Mantel-Haenszel test}
\usage{
groupwiseCMH(
  x,
  group = 3,
  fisher = TRUE,
  gtest = FALSE,
  chisq = FALSE,
  method = "fdr",
  correct = "none",
  digits = 3,
  ...
)
}
\arguments{
\item{x}{A three-way contingency table.}

\item{group}{The dimension of the table to use as the grouping variable.
Will be \code{1}, \code{2}, or \code{3}.}

\item{fisher}{If \code{TRUE}, conducts Fisher exact test.}

\item{gtest}{If \code{TRUE}, conducts G test of association.}

\item{chisq}{If \code{TRUE}, conducts Chi-square test of association.}

\item{method}{The method to use to adjust p-values.  See \code{?p.adjust}.}

\item{correct}{The correction to apply to the G test. 
See \code{GTest}.}

\item{digits}{The number of digits for numbers in the output.}

\item{...}{Other arguments passed to \code{chisq.test} or \code{GTest}.}
}
\value{
A data frame of groups, test used, p-values, and adjusted p-values.
}
\description{
Conducts groupwise tests of association on a three-way 
             contingency table.
}
\details{
If more than one of \code{fisher}, \code{gtest}, or \code{chisq} is
         set to \code{TRUE}, only one type of test of association
         will be conducted.
}
\examples{
### Post-hoc for Cochran-Mantel-Haenszel test
data(AndersonBias)
Table = xtabs(Count ~ Sex + Result + County,
              data=AndersonBias)
ftable(Table)
mantelhaen.test(Table)
groupwiseCMH(Table,
             group   = 3,
             fisher  = TRUE,
             gtest   = FALSE,
             chisq   = FALSE,
             method  = "fdr",
             correct = "none",
             digits  = 3)
                      
}
\references{
\url{http://rcompanion.org/handbook/H_06.html}
}
\seealso{
\code{\link{nominalSymmetryTest}}, \code{\link{pairwiseMcnemar}},
         \code{\link{pairwiseNominalIndependence}}, 
         \code{\link{pairwiseNominalMatrix}}
}
\author{
Salvatore Mangiafico, \email{mangiafico@njaes.rutgers.edu}
}
\concept{Cochran Mantel Haenszel post-hoc fisher Chi square G}
