% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Statistics.R
\name{corrCMB}
\alias{corrCMB}
\title{Sample correlation function}
\usage{
corrCMB(cmbdf, num.bins = 10, sample.size, max.dist = pi, breaks,
  equiareal = TRUE, calc.max.dist = FALSE)
}
\arguments{
\item{cmbdf}{is a \code{\link{CMBDataFrame}} or \code{\link{data.frame}}}

\item{num.bins}{specifies the number of bins}

\item{sample.size}{optionally specify the size of a simple random
sample to take before calculating correlation. This may be useful if
the full correlation computation is too slow.}

\item{max.dist}{an optional number between 0 and pi specifying the
maximum geodesic distance to use for calculating correlation. Only
used if \code{breaks} are  unspecified.}

\item{breaks}{optionally specify the breaks manually using a
vector giving the break points between cells. This vector
has length \code{num.bins} since the last break point is taken
as \code{max.dist}. If \code{equiareal = TRUE} then
these breaks should be \eqn{cos(r_i)} where \eqn{r_i} are radii.
If \code{equiareal = FALSE} then these breaks should be \eqn{r_i}.}

\item{equiareal}{if TRUE then the bins have equal spherical
area. If false then the bins have equal annular widths.
Default is TRUE.}

\item{calc.max.dist}{if TRUE then the \code{max.dist} will be
calculated from the locations in cmbdf. Otherwise
either \code{max.dist} must be specified or max.dist will
default to pi.}
}
\value{
#' An object of the class CMBCorrelation that is a modification of \code{\link[geoR]{variog}}
from the package \strong{geoR} with variogram values replaced by correlation.

The attribute "breaks" contains the break points used to create bins.
The result has \code{num.bins + 1} values since the first value at distance 0 is not
counted as a bin.

\describe{
\item{u}{a vector with distances.}
\item{v}{a vector with estimated correlation values at distances given in u.}
\item{n}{number of pairs in each bin}
\item{sd}{standard deviation of the values in each bin}
\item{bins.lim}{ limits defining the interval spanned by each bin}
\item{ind.bin}{a logical vector indicating whether the number of pairs
in each bin is greater or equal to the value in the argument pairs.min}
\item{var.mark}{variance of the data}
\item{beta.ols}{parameters of the mean part of the model fitted by ordinary
least squares}
\item{output.type}{echoes the option argument}
\item{max.dist}{maximum distance between pairs allowed in the correlation calculations}
\item{n.data}{number of data}
\item{direction}{direction for which the correlation was computed}
\item{call}{the function call}
}
}
\description{
This function provides an empirical correlation function for data
in a \code{\link{CMBDataFrame}} or data.frame. It assumes that data are from a stationary spherical
random field and the correlation depends only on a geodesic distance between locations.
Output is a binned correlation.
}
\examples{

## Download the map first
# downloadCMBMap(foreground = "smica", nside = 1024)
# df <- CMBDataFrame("CMB_map_smica1024.fits")
# cmbdf <- sampleCMB(df, sample.size = 100000)
# corcmb <- corrCMB(cmbdf, max.dist = 0.03, num.bins = 10, sample.size=1000)
# corcmb

}
\references{
\strong{geoR} package,\code{\link[geoR]{variog}},  \code{\link{variogramCMB}}, \code{\link{covCMB}}
}
