% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Statistics.R
\name{covPwSp}
\alias{covPwSp}
\title{Covariance estimate via power spectra}
\usage{
covPwSp(PowerSpectra, Ns)
}
\arguments{
\item{PowerSpectra}{A data frame which first
column lists values of multipole
moments and the second column gives
the corresponding values of CMB power
spectra.}

\item{Ns}{A number of points in which
the covariance estimate is computed on
the interval [-1,1]}
}
\value{
A data frame which first column is 1-d grid starting at -1+1/Ns and
finishing at 1 with the step 2/Ns. The second column is the values of
estimated covariances on this grid.
}
\description{
This function provides a covariance estimate
using the values of the estimated
power spectra.
}
\examples{

## Download the power spectrum first
# N <- 20000
# COM_PowerSpectra <- downloadCMBPS(link=1)
#
# Cov_est <- covPwSp(COM_PowerSpectra[,1:2], N)
# plot(Cov_est, type="l")

## Plot the covariance estimate as a function of angular distances
# plot(acos(Cov_est[,1]), Cov_est[,2], type ="l",
#      xlab ="angular distance", ylab ="Estimated Covariance")

}
\references{
Formula (2.1) in Baran A., Terdik G. Power spectrum estimation
of spherical random fields based on covariances. Annales Mathematicae et
Informaticae 44 (2015) pp. 15–22.

Power Spectra data are from Planck Legacy Archive
\url{http://pla.esac.esa.int/pla/#cosmology}
}
