% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segments.R
\name{delineate_segments}
\alias{delineate_segments}
\title{Split a river corridor into segments}
\usage{
delineate_segments(corridor, network, river, angle_threshold = 100)
}
\arguments{
\item{corridor}{The river corridor as a simple feature geometry}

\item{network}{The spatial network to be used for the segmentation}

\item{river}{The river centerline as a simple feature geometry}

\item{angle_threshold}{Only consider angles above this threshold (in degrees)
to form continuous strokes in the network. See \code{\link[rcoins:stroke]{rcoins::stroke()}} for
more details.}
}
\value{
Segment polygons as a simple feature geometry
}
\description{
Segments are defined as corridor subregions separated by river-crossing
transversal lines that form continuous strokes in the network.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
bucharest_osm <- get_osm_example_data()
corridor <- bucharest_dambovita$corridor
network <- rbind(bucharest_osm$streets, bucharest_osm$railways) |>
  as_network()
river <- bucharest_osm$river_centerline |> sf::st_geometry()
delineate_segments(corridor, network, river)
\dontshow{\}) # examplesIf}
}
