% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdataretriever.R
\name{install_postgres}
\alias{install_postgres}
\title{Install datasets via the Data Retriever.}
\usage{
install_postgres(
  dataset,
  user = "postgres",
  password = "",
  host = "localhost",
  port = 5432,
  database = "postgres",
  database_name = "{db}",
  table_name = "{db}.{table}",
  bbox = list(),
  debug = FALSE,
  use_cache = TRUE,
  force = FALSE,
  hash_value = NULL
)
}
\arguments{
\item{dataset}{the name of the dataset that you wish to install or path to a committed dataset zip file}

\item{user}{username for database connection}

\item{password}{password for database connection}

\item{host}{hostname for connection}

\item{port}{port number for connection}

\item{database}{the database name default is postres}

\item{database_name}{database schema name in which dataset will be installed}

\item{table_name}{table name specified especially for datasets
containing one file}

\item{bbox}{Optional extent values used to fetch data from the spatial dataset}

\item{debug}{Setting TRUE helps in debugging in case of errors}

\item{use_cache}{Setting FALSE reinstalls scripts even if they are already installed}

\item{force}{Setting TRUE doesn't prompt for confirmation while installing committed datasets when changes are discovered in environment}

\item{hash_value}{the hash value of committed dataset when installing from provenance directory}
}
\description{
Data is stored in PostgreSQL database
}
\examples{
\donttest{
rdataretriever::install_postgres(dataset = "portal", user = "postgres", password = "abcdef")
}
}
