% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.rd.R
\name{plot.rd}
\alias{plot.rd}
\title{Plot the Regression Discontinuity
 
\code{plot.rd} plots the relationship between the running variable and the outcome.
It is based on the \code{\link[rdd]{plot.RD}} function in the \pkg{rdd} package.}
\usage{
\method{plot}{rd}(x, preds = NULL, fit_line = c("linear", "quadratic",
  "cubic", "optimal", "half", "double"), fit_ci = c("area", "dot", "hide"),
  fit_ci_level = 0.95, bin_n = 20, bin_level = 0.95,
  bin_size = c("shade", "size"), quant_bin = TRUE, xlim = NULL,
  ylim = NULL, include_rugs = FALSE, ...)
}
\arguments{
\item{x}{An \code{rd} object, typically the result of \code{\link{rd_est}}.}

\item{preds}{Predictions generated by \code{\link{predict.rd}}.}

\item{fit_line}{Models to be shown as fitted lines.}

\item{fit_ci}{Whether and how to plot prediction CIs around the fitted lines.}

\item{fit_ci_level}{Confidence level of prediction CIs.}

\item{bin_n}{Number of bins for binned data points (plot raw data points if = 0; 
suppress data points if < 0).}

\item{bin_level}{Confidence level for CIs around binned data points.}

\item{bin_size}{How to plot the number of observations in each bin.}

\item{quant_bin}{Whether the data are binned per quantiles.}

\item{xlim}{x-axis limits.}

\item{ylim}{y-axis limits.}

\item{include_rugs}{Whether to include 1d plot for both axes.}

\item{...}{Additional arguments affecting the plots produced.}
}
\description{
Plot the Regression Discontinuity
 
\code{plot.rd} plots the relationship between the running variable and the outcome.
It is based on the \code{\link[rdd]{plot.RD}} function in the \pkg{rdd} package.
}
\examples{
 
dat <- data.frame(x = runif(1000, -1, 1), cov = rnorm(1000))
dat$tr <- as.integer(dat$x >= 0)
dat$y <- 3 + 2 * dat$x + 3 * dat$cov + 10 * (dat$x >= 0) + rnorm(1000)
rd <- rd_est(y ~ x + tr | cov, data = dat, cutpoint = 0) 
plot(rd)
}
