% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.rd.R
\name{predict.rd}
\alias{predict.rd}
\title{Prediction the Regression Discontinuity}
\usage{
\method{predict}{rd}(object, gran = 50, ...)
}
\arguments{
\item{object}{An \code{rd} object, typically the result of \code{\link{rd_est}}.}

\item{gran}{Granularity of the data points.}

\item{...}{Additional arguments affecting the predictions produced.}
}
\description{
\code{predict.rd} makes predictions of mean and standard deviation of RDs at different cutoffs.
}
\examples{
x <- runif(1000, -1, 1)
cov <- rnorm(1000)
y <- 3 + 2 * x + 3 * cov + 10 * (x >= 0) + rnorm(1000)
tr <- as.integer(x >= 0)
rd <- rd_est(y ~ x + tr | cov, cutpoint = 0) 
predict(rd)
}
