% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stdyInfo.R
\name{ddi_exPostEvaluation}
\alias{ddi_exPostEvaluation}
\alias{ddi_evaluationProcess}
\alias{ddi_evaluator}
\alias{ddi_outcomes}
\title{exPostEvaluation and its child nodes}
\usage{
ddi_exPostEvaluation(...)

ddi_evaluationProcess(...)

ddi_evaluator(...)

ddi_outcomes(...)
}
\arguments{
\item{...}{Child nodes or attributes.}
}
\value{
A ddi_node object.
}
\description{
Post Evaluation Procedures describes evaluation procedures not addressed in
data evaluation processes. These may include issues such as timing of the
study, sequencing issues, cost/budget issues, relevance, institutional or
legal arrangements etc. of the study. More information on these elements,
especially their allowed attributes, can be found in the references.
}
\details{
\emph{Parent nodes}

\code{exPostEvaluation} is contained in \code{stdyInfo}.

\emph{exPostEvaluation specific child nodes}
\itemize{
\item \code{ddi_evaluationProcess()} describes the evaluation process followed.
\item \code{ddi_evaluator()} identifies persons or organizations involved in the
evaluation.
\item \code{ddi_outcomes()} describes the outcomes of the evaluation.
}
}
\examples{
ddi_exPostEvaluation()

# Functions that need to be wrapped in ddi_exPostEvaluation()

ddi_evaluationProcess("This dataset was evaluated using the following methods...")

ddi_evaluator(affiliation = "United Nations",
              abbr = "UNSD",
              role = "consultant",
              "United Nations Statistical Division")
              
ddi_outcomes("The following steps were highly effective in increasing response 
             rates, and should be repeated in the next collection cycle...")

}
\references{
\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/exPostEvaluation.html}{exPostEvaluation documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/evaluationProcess.html}{evaluationProcess documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/evaluator.html}{evaluator documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/outcomes.html}{outcomes documentation}
}
