% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/covarTests.R
\name{covarTest_dis}
\alias{covarTest_dis}
\alias{covarTest_dis.rdd_data}
\alias{covarTest_dis.rdd_reg}
\title{Testing for balanced covariates: equality of distribution}
\usage{
covarTest_dis(object, bw, exact = NULL, p.adjust = c("none", "holm", "BH",
  "BY", "hochberg", "hommel", "bonferroni"))

\method{covarTest_dis}{rdd_data}(object, bw = NULL, exact = FALSE,
  p.adjust = c("none", "holm", "BH", "BY", "hochberg", "hommel",
  "bonferroni"))

\method{covarTest_dis}{rdd_reg}(object, bw = NULL, exact = FALSE,
  p.adjust = c("none", "holm", "BH", "BY", "hochberg", "hommel",
  "bonferroni"))
}
\arguments{
\item{object}{object of class rdd_data}

\item{bw}{a bandwidth}

\item{exact}{Argument of the \code{\link{ks.test}} function: NULL or a logical indicating whether an exact p-value should be computed.}

\item{p.adjust}{Whether to adjust the p-values for multiple testing. Uses the \code{\link{p.adjust}} function}

\item{\ldots}{currently not used}
}
\value{
A data frame  with, for each covariate, the K-S statistic and its p-value.
}
\description{
Tests equality of distribution with a Kolmogorov-Smirnov for each covariates, between the two full groups or around the discontinuity threshold
}
\examples{
data(house)

## Add randomly generated covariates
set.seed(123)
n_Lee <- nrow(house)
Z <- data.frame(z1 = rnorm(n_Lee, sd=2),
                z2 = rnorm(n_Lee, mean = ifelse(house<0, 5, 8)),
                z3 = sample(letters, size = n_Lee, replace = TRUE))
house_rdd_Z <- rdd_data(y = house$y, x = house$x, covar = Z, cutpoint = 0)

## Kolmogorov-Smirnov test of equality in distribution:
covarTest_dis(house_rdd_Z, bw=0.3)

## Can also use function covarTest_dis() for a t-test for equality of means around cutoff:
covarTest_mean(house_rdd_Z, bw=0.3)
## covarTest_dis works also on regression outputs (bw will be taken from the model)
reg_nonpara <- rdd_reg_np(rdd_object=house_rdd_Z)
covarTest_dis(reg_nonpara)
}
\author{
Matthieu Stigler <\email{Matthieu.Stigler@gmail.com}>
}
\seealso{
\code{\link{covarTest_mean}} for the t-test of equality of means
}

