% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/reg_lm.R
\name{rdd_reg_lm}
\alias{rdd_reg_lm}
\title{Parametric polynomial estimator of the regression discontinuity}
\usage{
rdd_reg_lm(rdd_object, covariates = NULL, order = 1, bw = NULL,
  slope = c("separate", "same"), covar.opt = list(strategy = c("include",
  "residual"), slope = c("same", "separate"), bw = NULL),
  covar.strat = c("include", "residual"), weights)
}
\arguments{
\item{rdd_object}{Object of class rdd_data created by \code{\link{rdd_data}}}

\item{covariates}{Formula to include covariates}

\item{order}{Order of the polynomial regression.}

\item{bw}{A bandwidth to specify the subset on which the parametric regression is estimated}

\item{slope}{Whether slopes should be different on left or right (separate), or the same.}

\item{covar.opt}{Options for the inclusion of covariates. Way to include covariates, either in the main regression (\code{include}) or as regressors of y in a first step (\code{residual}).}

\item{covar.strat}{DEPRECATED, use covar.opt instead.}

\item{weights}{Optional weights to pass to the lm function. Note this cannot be entered together with \code{bw}}
}
\value{
An object of class rdd_reg_lm and class lm, with specific print and plot methods
}
\description{
Compute a parametric polynomial regression of the ATE,
possibly on the range specified by bandwidth
}
\details{
This function estimates the standard \emph{discontinuity regression}:
\deqn{Y=\alpha+\tau D+\beta_{1}(X-c)+\beta_{2}D(X-c)+\epsilon}
with \eqn{\tau} the main parameter of interest. Several versions of the regression can be estimated, either restricting the slopes to be the same,
i.e \eqn{\beta_{1}=\beta_{2}} (argument \code{slope}). The order of the polynomial in \eqn{X-c} can also be adjusted with argument \code{order}.
Note that a value of zero can be used, which corresponds to the simple \emph{difference in means}, that one would use if the samples were random.
Covariates can also be added in the regression, according to the two strategies discussed in Lee and Lemieux (2010, sec 4.5), through argument \code{covar.strat}:
\describe{
\item{include}{Covariates are simply added as supplementary regressors in the RD equation}
\item{residual}{The dependent variable is first regressed on the covariates only, then the RDD equation is applied on the residuals from this first step}}
The regression can also be estimated in a neighborhood of the cutpoint with the argument \code{bw}. This make the parametric regression resemble
the non-parametric local kernel \code{\link{rdd_reg_np}}. Similarly, weights can also be provided (but not simultaneously to \code{bw}).

The returned object is a classical \code{lm} object, augmented with a \code{RDDslot}, so usual methods can be applied. As is done in general in R,
heteroskeadsticity-robust inference can be done later on with the usual function from package \pkg{sandwich}. For the case of clustered observations
a specific function \code{\link{clusterInf}} is provided.
}
\examples{
## Step 0: prepare data
data(house)
house_rdd <- rdd_data(y=house$y, x=house$x, cutpoint=0)
## Step 2: regression
# Simple polynomial of order 1:
reg_para <- rdd_reg_lm(rdd_object=house_rdd)
print(reg_para)
plot(reg_para)

# Simple polynomial of order 4:
reg_para4 <- rdd_reg_lm(rdd_object=house_rdd, order=4)
reg_para4
plot(reg_para4)

# Restrict sample to bandwidth area:
bw_ik <- rdd_bw_ik(house_rdd)
reg_para_ik <- rdd_reg_lm(rdd_object=house_rdd, bw=bw_ik, order=4)
reg_para_ik
plot(reg_para_ik)
}

