% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LogNormModVar.R
\docType{class}
\name{LogNormModVar}
\alias{LogNormModVar}
\title{A model variable whose uncertainty follows a log Normal distribution}
\description{
An R6 class representing a model variable with log Normal 
uncertainty.
}
\details{
A model variable for which the uncertainty in the point estimate can
be modelled with a log Normal distribution. One of seven parametrizations
defined by Swat \emph{et al} can be used. Inherits from \code{ModVar}.
}
\references{
{ 
 Briggs A, Claxton K and Sculpher M. Decision Modelling for Health
 Economic Evaluation. Oxford 2006, ISBN 978-0-19-852662-9.

 Leaper DJ, Edmiston CE and Holy CE. Meta-analysis of the potential
 economic impact following introduction of absorbable antimicrobial 
 sutures. \emph{British Journal of Surgery} 2017;\bold{104}:e134-e144.

 Swat MJ, Grenon P and Wimalaratne S. Ontology and Knowledge Base of
 Probability Distributions. \acronym{EMBL-EBI} Technical Report
 (ProbOnto 2.5), 13 January 2017, 
 \url{https://sites.google.com/site/probonto/download}.
}
}
\author{
Andrew J. Sims \email{andrew.sims@newcastle.ac.uk}
}
\section{Super class}{
\code{\link[rdecision:ModVar]{rdecision::ModVar}} -> \code{LogNormModVar}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{LogNormModVar$new()}}
\item \href{#method-is_probabilistic}{\code{LogNormModVar$is_probabilistic()}}
\item \href{#method-clone}{\code{LogNormModVar$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="ModVar" data-id="SD">}\href{../../rdecision/html/ModVar.html#method-SD}{\code{rdecision::ModVar$SD()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="ModVar" data-id="description">}\href{../../rdecision/html/ModVar.html#method-description}{\code{rdecision::ModVar$description()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="ModVar" data-id="distribution">}\href{../../rdecision/html/ModVar.html#method-distribution}{\code{rdecision::ModVar$distribution()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="ModVar" data-id="get">}\href{../../rdecision/html/ModVar.html#method-get}{\code{rdecision::ModVar$get()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="ModVar" data-id="is_expression">}\href{../../rdecision/html/ModVar.html#method-is_expression}{\code{rdecision::ModVar$is_expression()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="ModVar" data-id="mean">}\href{../../rdecision/html/ModVar.html#method-mean}{\code{rdecision::ModVar$mean()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="ModVar" data-id="mode">}\href{../../rdecision/html/ModVar.html#method-mode}{\code{rdecision::ModVar$mode()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="ModVar" data-id="quantile">}\href{../../rdecision/html/ModVar.html#method-quantile}{\code{rdecision::ModVar$quantile()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="ModVar" data-id="r">}\href{../../rdecision/html/ModVar.html#method-r}{\code{rdecision::ModVar$r()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="ModVar" data-id="set">}\href{../../rdecision/html/ModVar.html#method-set}{\code{rdecision::ModVar$set()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="ModVar" data-id="units">}\href{../../rdecision/html/ModVar.html#method-units}{\code{rdecision::ModVar$units()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create a model variable with log normal uncertainty.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LogNormModVar$new(description, units, p1, p2, parametrization = "LN1")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{description}}{A character string describing the variable.}

\item{\code{units}}{Units of the quantity; character string.}

\item{\code{p1}}{First hyperparameter, a measure of location. 
See \emph{Details}.}

\item{\code{p2}}{Second hyperparameter, a measure of spread.
See \emph{Details}.}

\item{\code{parametrization}}{A character string taking one of the values
\verb{"LN1"} (default) through \verb{"LN7"} (see \emph{Details}).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{LogNormModVar} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-is_probabilistic"></a>}}
\if{latex}{\out{\hypertarget{method-is_probabilistic}{}}}
\subsection{Method \code{is_probabilistic()}}{
Tests whether the model variable is probabilistic, i.e. a random
variable that follows a distribution, or an expression involving
random variables, some of which follow distributions.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LogNormModVar$is_probabilistic()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{TRUE} if probabilistic
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LogNormModVar$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
