% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ukair_get_coordinates.R
\name{ukair_get_coordinates}
\alias{ukair_get_coordinates}
\title{Get Easting and Northing coordinates from DEFRA}
\usage{
ukair_get_coordinates(ids)
}
\arguments{
\item{ids}{contains the station identification code defined by DEFRA. It can
be: a) an alphanumeric string, b) a vector of strings or c) a data frame. In
the latter case, the column containing the codes should be named "UK.AIR.ID",
all the other columns will be ignored.}
}
\value{
A data.frame containing at least five columns named "UK.AIR.ID",
"Easting", "Northing", "Latitude" and "Longitude".
}
\description{
This function takes as input the UK AIR ID and returns Easting
and Northing coordinates (British National Grid, EPSG:27700).
}
\details{
If the input is a data frame with some of the columns named
"UK.AIR.ID", "Northing" and "Easting", the function only infills missing
Northing/Easting values (if available on the relevant webpage).
}
\examples{
 \dontrun{
 # Case a: alphanumeric string
 ukair_get_coordinates("UKA12536")

 # Case b: vector of strings
 ukair_get_coordinates(c("UKA15910", "UKA15956", "UKA16663", "UKA16097"))

 # Case c: data frame
 ukair_get_coordinates(ukair_catalogue()[1:10,])
 }

}
