% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ProposalService.R
\name{dfp_getProposalsByStatement}
\alias{dfp_getProposalsByStatement}
\title{getProposalsByStatement}
\usage{
dfp_getProposalsByStatement(request_data, as_df = TRUE,
  verbose = FALSE)
}
\arguments{
\item{request_data}{a \code{list} or \code{data.frame} of data elements
to be formatted for a SOAP
request (XML format, but passed as character string)}

\item{as_df}{a boolean indicating whether to attempt to parse the result into
a \code{data.frame}}

\item{verbose}{a boolean indicating whether to print the service URL and POSTed XML}
}
\value{
a \code{data.frame} or \code{list} containing all the elements of a getProposalsByStatementResponse
}
\description{
Gets a ProposalPage of Proposal objects that satisfy the given Statement query. The following fields are supported for filtering: 
\itemize{
  \item{id}
  \item{dfpOrderId}
  \item{name}
  \item{status}
  \item{isArchived}
  \item{approvalStatus Only applicable for proposals using sales management}
  \item{lastModifiedDateTime}
  \item{thirdPartyAdServerId  Only applicable for non-programmatic proposals using sales management}
  \item{customThirdPartyAdServerName  Only applicable for non-programmatic proposals using sales management}
  \item{hasOfflineErrors}
  \item{isProgrammatic}
  \item{negotiationStatus Only applicable for programmatic proposals}
}
}
\examples{
\dontrun{
 dat <- list(filterStatement=list('query'="WHERE status='ACTIVE'")) 
 res <- dfp_getProposalsByStatement(dat)
}
}
\seealso{
\href{https://developers.google.com/ad-manager/api/reference/v201905/ProposalService#getProposalsByStatement}{Google Documentation for getProposalsByStatement}
}
