% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdbwhte.R
\name{rdbwhte}
\alias{rdbwhte}
\title{MSE-Optimal Bandwidth Selection for RD Heterogeneous Treatment
Effects Estimation}
\usage{
rdbwhte(
  y,
  x,
  c = 0,
  covs.hte = NULL,
  covs.eff = NULL,
  p = 1,
  kernel = "tri",
  vce = "hc3",
  cluster = NULL,
  bw.joint = FALSE
)
}
\arguments{
\item{y}{Outcome variable.}

\item{x}{Running variable.}

\item{c}{Cutoff value (default = 0).}

\item{covs.hte}{Covariate(s) for heterogeneous treatment effects (required).}

\item{covs.eff}{Additional covariates for efficiency (optional).}

\item{p}{Polynomial order (default = 1).}

\item{kernel}{Kernel type (default = "tri").}

\item{vce}{Variance estimator (default = "hc3").}

\item{cluster}{Optional cluster variable.}

\item{bw.joint}{Logical, use joint bandwidth selection (default = FALSE).}
}
\value{
A list with selected bandwidths and model information.
\item{W_lev}{vector of group level identifiers.}
\item{kernel}{kernel type used.}
\item{vce}{variance estimator used.}
\item{c}{cutoff value.}
\item{h}{vector containing the bandwidths used.}
\item{p}{order of the polynomial used for estimation of the regression function.}
\item{N}{vector with the original number of observations for each group.}
\item{Nh}{vector with the effective number of observations for each group.}
\item{coef_report}{internal value.}
\item{rdmodel}{rd model.}
}
\description{
\code{rdbwhte} computes MSE-optimal bandwidths for estimating
RD heterogeneous treatment effects based on covariates.

Companion commands: \code{\link{rdhte}} for RD HTE estimation and inference.

Related Stata and R packages useful for inference in RD designs are
described in the website: \url{https://rdpackages.github.io/}.
}
\examples{
set.seed(123)
n <- 5000
X <- runif(n, -1, 1)
W <- rbinom(n, 1, 0.5)
Y <- 3 + 2*X + 1.5*X^2 + 0.5*X^3 + sin(2*X) + 3*W*(X>=0) + rnorm(n)
rdbwhte.1 = rdbwhte(y=Y, x=X, covs.hte=factor(W))
summary(rdbwhte.1)
}
\references{
Calonico, Cattaneo, Farrell, Palomba and Titiunik (2025): rdhte: Learning Conditional Average Treatment Effects in RD Designs. \emph{Working paper}.

Calonico, Cattaneo, Farrell, Palomba and Titiunik (2025): Heterogenous Treatment Effects in Regression Discontinuity Designs. \emph{Working paper}
}
\seealso{
\code{\link{rdbwhte}}
}
\author{
Sebastian Calonico, University of California, Davis \email{scalonico@ucdavis.edu}.

Matias D. Cattaneo, Princeton University  \email{cattaneo@princeton.edu}.

Max H. Farrell, University of California, Santa Barbara \email{maxhfarrell@ucsb.edu}.

Filippo Palomba, Princeton University \email{fpalomba@princeton.edu}.

Rocio Titiunik, Princeton University \email{titiunik@princeton.edu}.
}
