% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/product_metric.R
\name{product_metric}
\alias{product_metric}
\title{Product metric}
\usage{
product_metric(..., p = 2)
}
\arguments{
\item{...}{Distance matrices or dist objects}

\item{p}{The power of the Minkowski distance}
}
\description{
Returns the p-product metric of two metric spaces. 
Works for output of `rdist`, `pdist` or `cdist`.
}
\examples{
# generate data
df <- matrix(runif(200), ncol = 2)
# distance matrices
dist_mat <- pdist(df)
dist_1 <- pdist(df[, 1])
dist_2 <- pdist(df[, 2])
# product distance matrix
dist_prod <- product_metric(dist_1, dist_2)
# check equality
all.equal(dist_mat, dist_prod)
}
