% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-metacommunity.R, R/metacommunity.R
\docType{class}
\name{metacommunity-class}
\alias{metacommunity-class}
\alias{is.metacommunity}
\alias{show,metacommunity-method}
\title{metacommunity-class}
\usage{
is.metacommunity(x)

\S4method{show}{metacommunity}(object)
}
\arguments{
\item{x}{any R object}

\item{object}{object of class \code{metacommunity}}
}
\value{
returns TRUE if its argument is a metacommunity, FALSE otherwise.
}
\description{
Container for class \code{metacommunity}.
}
\section{Fields}{

\describe{
\item{\code{type_abundance}}{two-dimensional \code{matrix} of mode \code{numeric}
with rows as types, columns as subcommunities, and elements containing  
relative abundances of types in subcommunities.  (in the phylogenetic case, 
this corresponds to the proportional abundance of historic species, which
is calculated from the proportional abundance of present day species)}

\item{\code{similarity}}{two-dimensional \code{matrix} of mode \code{numeric}; 
contains pairwise similarity between \emph{types}}

\item{\code{ordinariness}}{two-dimensional \code{matrix} of mode \code{numeric}; 
contains ordinariness of types}

\item{\code{subcommunity_weights}}{\code{vector} of mode \code{numeric}; contains
subcommunity weights}

\item{\code{type_weights}}{two-dimensional \code{matrix} of mode \code{numeric}; 
contains weight of types within a subcommunity}

\item{\code{raw_abundance}}{two-dimensional \code{matrix} of mode \code{numeric};
contains proportional abundance of samples (usually types, except in the 
phylogenetic case where samples correspond to the present day species)}

\item{\code{raw_structure}}{two-dimensional \code{matrix} of mode \code{numeric}; 
contains length of historic species (in phylogeny)}

\item{\code{parameters}}{\code{tibble} containing parameters associated with each 
historic species (in phylogeny)}
}}

