% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-metacommunity.R, R/metacommunity.R
\docType{class}
\name{metacommunity-class}
\alias{metacommunity-class}
\alias{show,metacommunity-method}
\title{metacommunity-class}
\usage{
\S4method{show}{metacommunity}(object)
}
\arguments{
\item{object}{object of class \code{metacommunity}}
}
\description{
Container for class \code{metacommunity}.
}
\section{Fields}{

\describe{
\item{\code{type_abundance}}{two-dimensional \code{matrix} of mode \code{numeric}
with rows as types, columns as subcommunities, and elements containing  
relative abundances of types in subcommunities.  In the phylogenetic case, 
this corresponds to the proportional abundance of historic species, which
is calculated from the proportional abundance of present day species.}

\item{\code{similarity}}{two-dimensional \code{matrix} of mode \code{numeric} with 
rows as types, columns as types, and elements containing pairwise 
similarities between types}

\item{\code{ordinariness}}{two-dimensional \code{matrix} of mode \code{numeric} 
with rows as types, columns as subcommunities, and elements containing the
ordinariness of types within subcommunities}

\item{\code{subcommunity_weights}}{\code{vector} of mode \code{numeric}; contains
subcommunity weights}

\item{\code{type_weights}}{two-dimensional \code{matrix} of mode \code{numeric}, 
with rows as types, columns as subcommunities, and elements containing 
weights of types within a subcommunity}

\item{\code{raw_abundance}}{[Phylogenetic] two-dimensional \code{matrix} of mode 
\code{numeric} with rows as types, columns as subcommunities, and elements 
containing the relative abundance of present day species}

\item{\code{raw_structure}}{[Phylogenetic] two-dimensional \code{matrix} of mode 
\code{numeric} with rows as historical species, columns as present day 
species, and elements containing historical species lengths within lineages}

\item{\code{parameters}}{[Phylogenetic] \code{tibble} containing parameters 
associated with each historic species in the phylogeny}
}}

