% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/net.R
\name{get_net_cooccur_edges}
\alias{get_net_cooccur_edges}
\alias{get_net_relations_edges}
\title{Retrieve co-occurrence edges list for a play as a data frame}
\usage{
get_net_cooccur_edges(play = NULL, corpus = NULL, ...)

get_net_relations_edges(play = NULL, corpus = NULL, ...)
}
\arguments{
\item{play}{Character, name of a play (you can find all play names in
\code{"playName"} column within an object returned by
\code{\link{get_dracor}}). Character vector (longer than 1) is not
supported.}

\item{corpus}{Character, name of the corpus (you can find all corpus names in
\code{name} column within an object returned by
\code{\link{get_dracor_meta}}).}

\item{...}{Additional arguments passed to \code{\link{dracor_api}}.}
}
\value{
data frame with edges (each row = one edge of a network).
}
\description{
\code{get_net_cooccur_edges()} requests edges list for a play network, given
corpus and play names. Each row represents co-occurrences of two characters
in a play — number of scenes where two characters appeared together. This
edges list can be used to construct a network for a play.
}
\section{Functions}{
\itemize{
\item \code{get_net_relations_edges()}: Retrieves kinship and other relationship
data, following the encoding scheme proposed in
\insertCite{wiedmer_nathalie_2020_4621778}{rdracor}.

}}
\examples{
get_net_cooccur_edges(play = "lessing-emilia-galotti", corpus = "ger")
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{get_net_cooccur_igraph}}
\code{\link{get_net_cooccur_gexf}} \code{\link{get_net_cooccur_graphml}}
\code{\link{get_net_cooccur_metrics}} \code{\link{get_net_relations_igraph}}
}
