% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{re2_split}
\alias{re2_split}
\title{Split string based on pattern}
\usage{
re2_split(string, pattern, simplify = FALSE, n = Inf)
}
\arguments{
\item{string}{A character vector, or an object which can be coerced to one.}

\item{pattern}{Character string containing a regular expression,
 or a pre-compiled regular expression (or a vector of character
 strings and pre-compiled regular expressions). \cr
See \code{\link{re2_regexp}} for available options. \cr
See \link{re2_syntax} for regular expression syntax. \cr}

\item{simplify}{If FALSE, the default, return a list of string vectors.
If TRUE, return a string matrix.}

\item{n}{Number of string pieces to return. Default (Inf) returns all.}
}
\value{
A list of string vectors or a string matrix. See option.
}
\description{
Vectorized over string and pattern.
}
\examples{
panagram <- c(
  "The quick brown fox jumps over the lazy dog",
  "How vexingly quick daft zebras jump!"
)

re2_split(panagram, " quick | over | zebras ")
re2_split(panagram, " quick | over | zebras ", simplify = TRUE)

# Use compiled regexp
re <- re2_regexp("quick | over |how ", case_sensitive = FALSE)
re2_split(panagram, re)
re2_split(panagram, re, simplify = TRUE)

# Restrict number of matches
re2_split(panagram, " quick | over | zebras ", n = 2)
}
\seealso{
\code{\link{re2_regexp}} for options to regular expression,
  \link{re2_syntax} for regular expression syntax, and
  \code{\link{re2_match}} to extract matched groups.
}
