% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replace.R
\name{re2_replace}
\alias{re2_replace}
\alias{re2_replace_all}
\title{Replace matched patterns in a string.}
\usage{
re2_replace(string, pattern, replacement, parallel = FALSE,
  grain_size = 1e+05, ...)

re2_replace_all(string, pattern, replacement, parallel = FALSE,
  grain_size = 1e+05, ...)
}
\arguments{
\item{string}{a character vector}

\item{pattern}{a pre-compiled regular expression or a string}

\item{replacement}{replace the first match or all of the match of \code{pattern} in \code{string} with "rewrite"}

\item{parallel}{use multithread}

\item{grain_size}{a minimum chunk size for tuning the behavior of parallel algorithms}

\item{...}{further arguments passed to \code{\link{re2}}}
}
\value{
For \code{\link{re2_replace}}, a character vector. For \code{\link{re2_replace_all}}, a character vector with the number of replacements.
}
\description{
Replace the the first match or all matches of \code{pattern} in \code{string} with \code{replacement}.
}
\details{
Within \code{replacement}, backslash-escaped digits (\\1 to \\9) can be
used to insert text matching corresponding parenthesized group
from the pattern.  \\0 in \code{replacement} refers to the entire matching
text.

Vectorised over strings, patterns and replacements.
}
\examples{
# replace one or more b, prefer more
regexp = re2("b+")
re2_replace_all("yabba dabba doo", regexp,"d")
re2_replace("yabba dabba doo", "b+","d")

# trim string
pattern = "^\\\\s+|\\\\s+$"
re2_replace_all(c("  abc  "," this is "), pattern, "")

# mask the middle three digits of a US phone number
texts = c("415-555-1234",
          "650-555-2345",
          "(416)555-3456",
          "202 555 4567",
          "4035555678",
          "1 416 555 9292")

us_phone_pattern = re2("(1?[\\\\s-]?\\\\(?\\\\d{3}\\\\)?[\\\\s-]?)(\\\\d{3})([\\\\s-]?\\\\d{4})")

re2_replace(texts, us_phone_pattern, "\\\\1***\\\\3")

# show_regex(us_phone_pattern)

}
