% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split.R
\name{re2_split}
\alias{re2_split}
\alias{re2_split_fixed}
\title{Split a string into pieces.}
\usage{
re2_split(string, pattern, n = Inf, parallel = FALSE, grain_size = 10000,
  ...)

re2_split_fixed(string, pattern, n, parallel = FALSE, grain_size = 10000,
  ...)
}
\arguments{
\item{string}{a character vector}

\item{pattern}{a character vector or pre-compiled regular expressions}

\item{n}{number of pieces to return. Default (Inf) for
\code{\link{re2_split}} uses all possible split positions.
For \code{\link{re2_split_fixed}}, if n is greater than
 the number of pieces, the result will be padded with
 empty strings.}

\item{parallel}{use multithread}

\item{grain_size}{a minimum chunk size for tuning the behavior of parallel algorithms}

\item{...}{further arguments passed to \code{\link{re2}}}
}
\value{
For \code{\link{re2_split_fixed}}, a character matrix with n columns.

For \code{\link{re2_split}}, a list of character vectors.
}
\description{
Split a string into pieces. Vectorised over string and pattern.
}
\examples{
re2_split("yabba dabba doo", " ")
re2_split_fixed(c("yabba dabba doo", "a bc"), " ", 2)
}
