% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/readGenalex.R
\name{dropLocus}
\alias{dropLocus}
\alias{dropLocus.genalex}
\title{Remove specified loci from data frame of class \code{'genalex'}}
\usage{
\method{dropLocus}{genalex}(x, drop.locus, quiet = FALSE, ...)
}
\arguments{
\item{x}{An annotated data frame of class \code{'genalex'}}

\item{drop.locus}{The names of one or more loci found in \code{x}}

\item{quiet}{If \code{FALSE}, produce an error if any of
                  \code{drop.locus} are not found in \code{x}.  If
                  \code{TRUE}, apply whichever of \code{drop.locus}
                  are found in \code{x} and return the result.}

\item{\dots}{Additional arguments, currently ignored}
}
\value{
A data frame containing the data in \code{x} after removing
loci specified by \code{drop.locus}, with attributes updated as
required.
}
\description{
Remove specified loci from the data frame of class \code{'genalex'}
and updates attributes
}
\examples{
data(Qagr_adult_genotypes)
newdat <- dropLocus(Qagr_adult_genotypes, "Oe09")
}
\author{
Douglas G. Scofield
}

